/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.MisconfiguredIndexException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexPopulationJobController;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.MultiPopulatorFactory;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;

public class IndexingService
extends LifecycleAdapter
implements IndexingUpdateService,
IndexingProvidersService {
    private final IndexSamplingController samplingController;
    private final IndexProxyCreator indexProxyCreator;
    private final IndexStoreView storeView;
    private final IndexProviderMap providerMap;
    private final IndexMapReference indexMapRef;
    private final Iterable<SchemaRule> schemaRules;
    private final Log internalLog;
    private final Log userLog;
    private final TokenNameLookup tokenNameLookup;
    private final MultiPopulatorFactory multiPopulatorFactory;
    private final LogProvider internalLogProvider;
    private final Monitor monitor;
    private final SchemaState schemaState;
    private final IndexPopulationJobController populationJobController;
    private final Map<Long, IndexProxy> indexesToDropAfterCompletedRecovery = new HashMap<Long, IndexProxy>();
    public static final Monitor NO_MONITOR = new MonitorAdapter();
    private volatile State state = State.NOT_STARTED;

    IndexingService(IndexProxyCreator indexProxyCreator, IndexProviderMap providerMap, IndexMapReference indexMapRef, IndexStoreView storeView, Iterable<SchemaRule> schemaRules, IndexSamplingController samplingController, TokenNameLookup tokenNameLookup, JobScheduler scheduler, SchemaState schemaState, MultiPopulatorFactory multiPopulatorFactory, LogProvider internalLogProvider, LogProvider userLogProvider, Monitor monitor) {
        this.indexProxyCreator = indexProxyCreator;
        this.providerMap = providerMap;
        this.indexMapRef = indexMapRef;
        this.storeView = storeView;
        this.schemaRules = schemaRules;
        this.samplingController = samplingController;
        this.tokenNameLookup = tokenNameLookup;
        this.schemaState = schemaState;
        this.multiPopulatorFactory = multiPopulatorFactory;
        this.internalLogProvider = internalLogProvider;
        this.monitor = monitor;
        this.populationJobController = new IndexPopulationJobController(scheduler);
        this.internalLog = internalLogProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
    }

    public void init() {
        this.validateDefaultProviderExisting();
        this.indexMapRef.modify(indexMap -> {
            EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
            for (SchemaRule rule : this.schemaRules) {
                IndexProxy indexProxy;
                if (rule instanceof ConstraintRule) {
                    ConstraintRule constraintRule = (ConstraintRule)rule;
                    if (!constraintRule.getConstraintDescriptor().enforcesUniqueness()) continue;
                    indexMap.putUniquenessConstraint(constraintRule);
                    continue;
                }
                StoreIndexDescriptor indexDescriptor = (StoreIndexDescriptor)rule;
                IndexProviderDescriptor providerDescriptor = indexDescriptor.providerDescriptor();
                IndexProvider provider = this.providerMap.lookup(providerDescriptor);
                InternalIndexState initialState = provider.getInitialState(indexDescriptor);
                indexStates.computeIfAbsent(initialState, internalIndexState -> new ArrayList()).add(new IndexLogRecord(indexDescriptor));
                this.internalLog.debug(this.indexStateInfo("init", initialState, indexDescriptor));
                switch (initialState) {
                    case ONLINE: {
                        this.monitor.initialState(indexDescriptor, InternalIndexState.ONLINE);
                        indexProxy = this.indexProxyCreator.createOnlineIndexProxy(indexDescriptor);
                        break;
                    }
                    case POPULATING: {
                        this.monitor.initialState(indexDescriptor, InternalIndexState.POPULATING);
                        indexProxy = this.indexProxyCreator.createRecoveringIndexProxy(indexDescriptor);
                        break;
                    }
                    case FAILED: {
                        this.monitor.initialState(indexDescriptor, InternalIndexState.FAILED);
                        IndexPopulationFailure failure = IndexPopulationFailure.failure(provider.getPopulationFailure(indexDescriptor));
                        indexProxy = this.indexProxyCreator.createFailedIndexProxy(indexDescriptor, failure);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("" + initialState);
                    }
                }
                indexMap.putIndexProxy(indexProxy);
            }
            this.logIndexStateSummary("init", indexStates);
            return indexMap;
        });
    }

    private void validateDefaultProviderExisting() {
        if (this.providerMap == null || this.providerMap.getDefaultProvider() == null) {
            throw new IllegalStateException("You cannot run the database without an index provider, please make sure that a valid provider (subclass of " + IndexProvider.class.getName() + ") is on your classpath.");
        }
    }

    public void start() {
        this.state = State.STARTING;
        this.performRecoveredIndexDropActions();
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("refresh", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)IndexProxy::refresh)));
        LongObjectHashMap rebuildingDescriptors = new LongObjectHashMap();
        this.indexMapRef.modify(arg_0 -> this.lambda$start$4((MutableLongObjectMap)rebuildingDescriptors, arg_0));
        this.samplingController.recoverIndexSamples();
        this.samplingController.start();
        rebuildingDescriptors.forEachKeyValue((LongObjectProcedure & Serializable)(indexId, descriptor) -> {
            IndexProxy proxy;
            if (descriptor.type() != IndexDescriptor.Type.UNIQUE) {
                return;
            }
            try {
                proxy = this.getIndexProxy(indexId);
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalStateException("What? This index was seen during recovery just now, why isn't it available now?", e);
            }
            this.monitor.awaitingPopulationOfRecoveredIndex((StoreIndexDescriptor)descriptor);
            this.awaitOnline(proxy);
        });
        this.state = State.RUNNING;
    }

    private void populateIndexesOfAllTypes(MutableLongObjectMap<StoreIndexDescriptor> rebuildingDescriptors, IndexMap indexMap) {
        EnumMap<EntityType, MutableLongObjectMap> rebuildingDescriptorsByType = new EnumMap<EntityType, MutableLongObjectMap>(EntityType.class);
        for (StoreIndexDescriptor descriptor : rebuildingDescriptors) {
            rebuildingDescriptorsByType.computeIfAbsent(descriptor.schema().entityType(), type -> new LongObjectHashMap()).put(descriptor.getId(), (Object)descriptor);
        }
        for (Map.Entry descriptorToPopulate : rebuildingDescriptorsByType.entrySet()) {
            IndexPopulationJob populationJob = this.newIndexPopulationJob((EntityType)descriptorToPopulate.getKey(), false);
            this.populate((MutableLongObjectMap<StoreIndexDescriptor>)((MutableLongObjectMap)descriptorToPopulate.getValue()), indexMap, populationJob);
        }
    }

    private void performRecoveredIndexDropActions() {
        this.indexesToDropAfterCompletedRecovery.values().forEach(index -> {
            try {
                index.drop();
            }
            catch (Exception e) {
                try {
                    index.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.indexesToDropAfterCompletedRecovery.clear();
    }

    private void populate(MutableLongObjectMap<StoreIndexDescriptor> rebuildingDescriptors, IndexMap indexMap, IndexPopulationJob populationJob) {
        rebuildingDescriptors.forEachKeyValue((LongObjectProcedure & Serializable)(indexId, descriptor) -> {
            IndexProxy proxy = this.indexProxyCreator.createPopulatingIndexProxy((StoreIndexDescriptor)descriptor, false, this.monitor, populationJob);
            proxy.start();
            indexMap.putIndexProxy(proxy);
        });
        this.startIndexPopulation(populationJob);
    }

    private void awaitOnline(IndexProxy proxy) {
        block7: while (true) {
            switch (1.$SwitchMap$org$neo4j$internal$kernel$api$InternalIndexState[proxy.getState().ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    IndexPopulationFailure populationFailure = proxy.getPopulationFailure();
                    String message = String.format("Index %s entered %s state while recovery waited for it to be fully populated.", proxy.getDescriptor(), InternalIndexState.FAILED);
                    String causeOfFailure = populationFailure.asString();
                    throw new IllegalStateException(IndexPopulationFailure.appendCauseOfFailure(message, causeOfFailure));
                }
                case 3: {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Waiting for index to become ONLINE was interrupted", e);
                    }
                }
                continue block7;
            }
            break;
        }
        throw new IllegalStateException(proxy.getState().name());
    }

    public void shutdown() throws ExecutionException, InterruptedException {
        this.state = State.STOPPED;
        this.samplingController.stop();
        this.populationJobController.stop();
        this.closeAllIndexes();
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        long indexId = this.indexMapRef.getOnlineIndexId(descriptor);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexUpdatesAndSize(indexId, output);
        return output;
    }

    public double indexUniqueValuesPercentage(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        long indexId = this.indexMapRef.getOnlineIndexId(descriptor);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexSample(indexId, output);
        long unique = output.readFirst();
        long size = output.readSecond();
        if (size == 0L) {
            return 1.0;
        }
        return (double)unique / (double)size;
    }

    @Override
    public void validateBeforeCommit(SchemaDescriptor index, Value[] tuple) {
        this.indexMapRef.validateBeforeCommit(index, tuple);
    }

    @Override
    public IndexDescriptor getBlessedDescriptorFromProvider(IndexDescriptor index) throws MisconfiguredIndexException {
        IndexProvider provider = this.providerMap.lookup(index.providerDescriptor());
        return provider.bless(index);
    }

    @Override
    public IndexProviderDescriptor indexProviderByName(String providerName) {
        return this.providerMap.lookup(providerName).getProviderDescriptor();
    }

    @Override
    public void apply(IndexUpdates updates) throws IndexEntryConflictException {
        if (this.state == State.NOT_STARTED) {
            this.apply(updates, IndexUpdateMode.RECOVERY);
        } else if (this.state == State.RUNNING || this.state == State.STARTING) {
            this.apply(updates, IndexUpdateMode.ONLINE);
        } else {
            throw new IllegalStateException("Can't apply index updates " + Iterables.asList((Iterable)updates) + " while indexing service is " + (Object)((Object)this.state));
        }
    }

    private void apply(Iterable<IndexEntryUpdate<SchemaDescriptor>> updates, IndexUpdateMode updateMode) throws IndexEntryConflictException {
        try (IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(updateMode);){
            for (IndexEntryUpdate<SchemaDescriptor> indexUpdate : updates) {
                this.processUpdate(updaterMap, indexUpdate);
            }
        }
    }

    @Override
    public Iterable<IndexEntryUpdate<SchemaDescriptor>> convertToIndexUpdates(EntityUpdates entityUpdates, EntityType type) {
        Collection<SchemaDescriptor> relatedIndexes = this.indexMapRef.getRelatedIndexes(entityUpdates.entityTokensChanged(), entityUpdates.entityTokensUnchanged(), entityUpdates.propertiesChanged(), entityUpdates.isPropertyListComplete(), type);
        return entityUpdates.forIndexKeys(relatedIndexes, this.storeView, type);
    }

    public void createIndexes(StoreIndexDescriptor ... rules) {
        this.createIndexes(false, rules);
    }

    public void createIndexes(boolean verifyBeforeFlipping, StoreIndexDescriptor ... rules) {
        IndexPopulationStarter populationStarter = new IndexPopulationStarter(verifyBeforeFlipping, rules);
        this.indexMapRef.modify(populationStarter);
        populationStarter.startPopulation();
    }

    private void processUpdate(IndexUpdaterMap updaterMap, IndexEntryUpdate<SchemaDescriptor> indexUpdate) throws IndexEntryConflictException {
        IndexUpdater updater = updaterMap.getUpdater(indexUpdate.indexKey().schema());
        if (updater != null) {
            updater.process(indexUpdate);
        }
    }

    public void dropIndex(StoreIndexDescriptor rule) {
        this.indexMapRef.modify(indexMap -> {
            long indexId = rule.getId();
            IndexProxy index = indexMap.removeIndexProxy(indexId);
            if (this.state == State.RUNNING) {
                assert (index != null) : "Index " + rule + " doesn't exists";
                index.drop();
            } else if (index != null) {
                this.indexesToDropAfterCompletedRecovery.put(indexId, index);
            }
            return indexMap;
        });
    }

    public void putConstraint(ConstraintRule rule) {
        this.indexMapRef.modify(indexMap -> {
            if (rule.getConstraintDescriptor().enforcesUniqueness()) {
                indexMap.putUniquenessConstraint(rule);
            }
            return indexMap;
        });
    }

    public void removeConstraint(long ruleId) {
        this.indexMapRef.modify(indexMap -> {
            indexMap.removeUniquenessConstraint(ruleId);
            return indexMap;
        });
    }

    public void triggerIndexSampling(IndexSamplingMode mode) {
        this.internalLog.info("Manual trigger for sampling all indexes [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndexes(mode);
    }

    public void triggerIndexSampling(SchemaDescriptor descriptor, IndexSamplingMode mode) throws IndexNotFoundKernelException {
        String description = descriptor.userDescription(this.tokenNameLookup);
        this.internalLog.info("Manual trigger for sampling index " + description + " [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndex(this.indexMapRef.getIndexId(descriptor), mode);
    }

    private void dropRecoveringIndexes(IndexMap indexMap, LongIterable indexesToRebuild) {
        indexesToRebuild.forEach((LongProcedure & Serializable)idx -> {
            IndexProxy indexProxy = indexMap.removeIndexProxy(idx);
            assert (indexProxy != null);
            indexProxy.drop();
        });
    }

    public void activateIndex(long indexId) throws IndexNotFoundKernelException, IndexActivationFailedKernelException, IndexPopulationFailedKernelException {
        try {
            if (this.state == State.RUNNING) {
                IndexProxy index = this.getIndexProxy(indexId);
                index.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
                index.activate();
                this.internalLog.info("Constraint %s is %s.", new Object[]{index.getDescriptor(), InternalIndexState.ONLINE.name()});
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IndexActivationFailedKernelException(e, "Unable to activate index, thread was interrupted.");
        }
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(indexId);
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(descriptor);
    }

    public long getIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexId(descriptor);
    }

    public void validateIndex(long indexId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, UniquePropertyValueValidationException {
        this.getIndexProxy(indexId).validate();
    }

    public void forceAll(IOLimiter limiter) {
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("force", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)proxy -> proxy.force(limiter))));
    }

    private LongObjectProcedure<IndexProxy> indexProxyOperation(String name, ThrowingConsumer<IndexProxy, Exception> operation) {
        return (LongObjectProcedure & Serializable)(id, indexProxy) -> {
            try {
                operation.accept(indexProxy);
            }
            catch (Exception e) {
                try {
                    IndexProxy proxy = this.indexMapRef.getIndexProxy(id);
                    throw new UnderlyingStorageException("Unable to " + name + " " + proxy, e);
                }
                catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                    // empty catch block
                }
            }
        };
    }

    private void closeAllIndexes() {
        this.indexMapRef.modify(indexMap -> {
            Iterable<IndexProxy> indexesToStop = indexMap.getAllIndexProxies();
            for (IndexProxy index : indexesToStop) {
                try {
                    index.close();
                }
                catch (Exception e) {
                    this.internalLog.error("Unable to close index", (Throwable)e);
                }
            }
            return new IndexMap();
        });
    }

    public LongSet getIndexIds() {
        Iterable<IndexProxy> indexProxies = this.indexMapRef.getAllIndexProxies();
        LongHashSet indexIds = new LongHashSet();
        for (IndexProxy indexProxy : indexProxies) {
            indexIds.add(indexProxy.getDescriptor().getId());
        }
        return indexIds;
    }

    public ResourceIterator<File> snapshotIndexFiles() throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
            snapshots.add(indexProxy.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshots.iterator());
    }

    private IndexPopulationJob newIndexPopulationJob(EntityType type, boolean verifyBeforeFlipping) {
        MultipleIndexPopulator multiPopulator = this.multiPopulatorFactory.create(this.storeView, this.internalLogProvider, type, this.schemaState);
        return new IndexPopulationJob(multiPopulator, this.monitor, verifyBeforeFlipping);
    }

    private void startIndexPopulation(IndexPopulationJob job) {
        this.populationJobController.startIndexPopulation(job);
    }

    private String indexStateInfo(String tag, InternalIndexState state, StoreIndexDescriptor descriptor) {
        return String.format("IndexingService.%s: index %d on %s is %s", tag, descriptor.getId(), descriptor.schema().userDescription(this.tokenNameLookup), state.name());
    }

    private void logIndexStateSummary(String method, Map<InternalIndexState, List<IndexLogRecord>> indexStates) {
        if (indexStates.isEmpty()) {
            return;
        }
        int mostPopularStateCount = Integer.MIN_VALUE;
        InternalIndexState mostPopularState = null;
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            if (indexStateEntry.getValue().size() <= mostPopularStateCount) continue;
            mostPopularState = indexStateEntry.getKey();
            mostPopularStateCount = indexStateEntry.getValue().size();
        }
        indexStates.remove(mostPopularState);
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            InternalIndexState state = indexStateEntry.getKey();
            List<IndexLogRecord> logRecords = indexStateEntry.getValue();
            for (IndexLogRecord logRecord : logRecords) {
                this.internalLog.info(this.indexStateInfo(method, state, logRecord.getDescriptor()));
            }
        }
        this.internalLog.info(String.format("IndexingService.%s: indexes not specifically mentioned above are %s", method, mostPopularState));
    }

    private void logIndexProviderSummary(Map<IndexProviderDescriptor, List<IndexLogRecord>> indexProviders) {
        Set deprecatedIndexProviders = Arrays.stream(GraphDatabaseSettings.SchemaIndex.values()).filter(GraphDatabaseSettings.SchemaIndex::deprecated).map(GraphDatabaseSettings.SchemaIndex::providerName).collect(Collectors.toSet());
        StringJoiner joiner = new StringJoiner(", ", "Deprecated index providers in use: ", ". Use procedure 'db.indexes()' to see what indexes use which index provider.");
        MutableBoolean anyDeprecated = new MutableBoolean();
        indexProviders.forEach((indexProviderDescriptor, indexLogRecords) -> {
            if (deprecatedIndexProviders.contains(indexProviderDescriptor.name())) {
                anyDeprecated.setTrue();
                int numberOfIndexes = indexLogRecords.size();
                joiner.add(indexProviderDescriptor.name() + " (" + numberOfIndexes + (numberOfIndexes == 1 ? " index" : " indexes") + ")");
            }
        });
        if (anyDeprecated.getValue().booleanValue()) {
            this.userLog.info(joiner.toString());
        }
    }

    public Collection<SchemaDescriptor> getRelatedIndexes(long[] labels, int propertyKeyId, EntityType entityType) {
        return this.indexMapRef.getRelatedIndexes(PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels, new int[]{propertyKeyId}, false, entityType);
    }

    public Collection<SchemaDescriptor> getRelatedIndexes(long[] labels, int[] propertyKeyIds, EntityType entityType) {
        return this.indexMapRef.getRelatedIndexes(labels, PrimitiveLongCollections.EMPTY_LONG_ARRAY, propertyKeyIds, true, entityType);
    }

    public Collection<IndexBackedConstraintDescriptor> getRelatedUniquenessConstraints(long[] labels, int propertyKeyId, EntityType entityType) {
        return this.indexMapRef.getRelatedConstraints(PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels, new int[]{propertyKeyId}, false, entityType);
    }

    public Collection<IndexBackedConstraintDescriptor> getRelatedUniquenessConstraints(long[] labels, int[] propertyKeyIds, EntityType entityType) {
        return this.indexMapRef.getRelatedConstraints(labels, PrimitiveLongCollections.EMPTY_LONG_ARRAY, propertyKeyIds, true, entityType);
    }

    public boolean hasRelatedSchema(long[] labels, int propertyKey, EntityType entityType) {
        return this.indexMapRef.hasRelatedSchema(labels, propertyKey, entityType);
    }

    public boolean hasRelatedSchema(int label, EntityType entityType) {
        return this.indexMapRef.hasRelatedSchema(label, entityType);
    }

    private /* synthetic */ IndexMap lambda$start$4(MutableLongObjectMap rebuildingDescriptors, IndexMap indexMap) {
        EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
        HashMap<IndexProviderDescriptor, List<IndexLogRecord>> indexProviders = new HashMap<IndexProviderDescriptor, List<IndexLogRecord>>();
        indexMap.forEachIndexProxy((LongObjectProcedure<IndexProxy>)(LongObjectProcedure & Serializable)(indexId, proxy) -> {
            InternalIndexState state = proxy.getState();
            CapableIndexDescriptor descriptor = proxy.getDescriptor();
            IndexProviderDescriptor providerDescriptor = descriptor.providerDescriptor();
            IndexLogRecord indexLogRecord = new IndexLogRecord((StoreIndexDescriptor)descriptor);
            indexStates.computeIfAbsent(state, internalIndexState -> new ArrayList()).add(indexLogRecord);
            indexProviders.computeIfAbsent(providerDescriptor, indexProviderDescriptor -> new ArrayList()).add(indexLogRecord);
            this.internalLog.debug(this.indexStateInfo("start", state, (StoreIndexDescriptor)descriptor));
            switch (state) {
                case ONLINE: {
                    break;
                }
                case POPULATING: {
                    rebuildingDescriptors.put(indexId, (Object)descriptor);
                    break;
                }
                case FAILED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + state);
                }
            }
        });
        this.logIndexStateSummary("start", indexStates);
        this.logIndexProviderSummary(indexProviders);
        this.dropRecoveringIndexes(indexMap, (LongIterable)rebuildingDescriptors.keySet());
        this.populateIndexesOfAllTypes((MutableLongObjectMap<StoreIndexDescriptor>)rebuildingDescriptors, indexMap);
        return indexMap;
    }

    private static final class IndexLogRecord {
        private final StoreIndexDescriptor descriptor;

        IndexLogRecord(StoreIndexDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public long getIndexId() {
            return this.descriptor.getId();
        }

        public StoreIndexDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    private final class IndexPopulationStarter
    implements Function<IndexMap, IndexMap> {
        private final boolean verifyBeforeFlipping;
        private final StoreIndexDescriptor[] descriptors;
        private IndexPopulationJob nodePopulationJob;
        private IndexPopulationJob relationshipPopulationJob;

        IndexPopulationStarter(boolean verifyBeforeFlipping, StoreIndexDescriptor[] descriptors) {
            this.verifyBeforeFlipping = verifyBeforeFlipping;
            this.descriptors = descriptors;
        }

        @Override
        public IndexMap apply(IndexMap indexMap) {
            for (StoreIndexDescriptor descriptor : this.descriptors) {
                IndexProxy index;
                if (IndexingService.this.state == State.NOT_STARTED) {
                    IndexingService.this.indexesToDropAfterCompletedRecovery.remove(descriptor.getId());
                }
                if ((index = indexMap.getIndexProxy(descriptor.getId())) != null && IndexingService.this.state == State.NOT_STARTED) {
                    indexMap.putIndexProxy(index);
                    continue;
                }
                boolean flipToTentative = descriptor.canSupportUniqueConstraint();
                if (IndexingService.this.state == State.RUNNING) {
                    if (descriptor.schema().entityType() == EntityType.NODE) {
                        this.nodePopulationJob = this.nodePopulationJob == null ? IndexingService.this.newIndexPopulationJob(EntityType.NODE, this.verifyBeforeFlipping) : this.nodePopulationJob;
                        index = IndexingService.this.indexProxyCreator.createPopulatingIndexProxy(descriptor, flipToTentative, IndexingService.this.monitor, this.nodePopulationJob);
                        index.start();
                    } else {
                        this.relationshipPopulationJob = this.relationshipPopulationJob == null ? IndexingService.this.newIndexPopulationJob(EntityType.RELATIONSHIP, this.verifyBeforeFlipping) : this.relationshipPopulationJob;
                        index = IndexingService.this.indexProxyCreator.createPopulatingIndexProxy(descriptor, flipToTentative, IndexingService.this.monitor, this.relationshipPopulationJob);
                        index.start();
                    }
                } else {
                    index = IndexingService.this.indexProxyCreator.createRecoveringIndexProxy(descriptor);
                }
                indexMap.putIndexProxy(index);
            }
            return indexMap;
        }

        void startPopulation() {
            if (this.nodePopulationJob != null) {
                IndexingService.this.startIndexPopulation(this.nodePopulationJob);
            }
            if (this.relationshipPopulationJob != null) {
                IndexingService.this.startIndexPopulation(this.relationshipPopulationJob);
            }
        }
    }

    public static class MonitorAdapter
    implements Monitor {
        @Override
        public void initialState(StoreIndexDescriptor descriptor, InternalIndexState state) {
        }

        @Override
        public void populationCompleteOn(StoreIndexDescriptor descriptor) {
        }

        @Override
        public void indexPopulationScanStarting() {
        }

        @Override
        public void indexPopulationScanComplete() {
        }

        @Override
        public void awaitingPopulationOfRecoveredIndex(StoreIndexDescriptor descriptor) {
        }
    }

    public static interface Monitor {
        public void initialState(StoreIndexDescriptor var1, InternalIndexState var2);

        public void populationCompleteOn(StoreIndexDescriptor var1);

        public void indexPopulationScanStarting();

        public void indexPopulationScanComplete();

        public void awaitingPopulationOfRecoveredIndex(StoreIndexDescriptor var1);
    }

    static enum State {
        NOT_STARTED,
        STARTING,
        RUNNING,
        STOPPED;

    }
}

