/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.Value;

public class AllStoreHolder
extends Read {
    private final StorageReader storageReader;
    private final ExplicitIndexStore explicitIndexStore;
    private final Procedures procedures;
    private final SchemaState schemaState;
    private final Dependencies dataSourceDependencies;

    public AllStoreHolder(StorageReader storageReader, KernelTransactionImplementation ktx, DefaultCursors cursors, ExplicitIndexStore explicitIndexStore, Procedures procedures, SchemaState schemaState, Dependencies dataSourceDependencies) {
        super(cursors, ktx);
        this.storageReader = storageReader;
        this.explicitIndexStore = explicitIndexStore;
        this.procedures = procedures;
        this.schemaState = schemaState;
        this.dataSourceDependencies = dataSourceDependencies;
    }

    public boolean nodeExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.nodeIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(reference)) {
                return true;
            }
        }
        return this.storageReader.nodeExists(reference);
    }

    public boolean nodeDeletedInTransaction(long node) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() && this.txState().nodeIsDeletedInThisTx(node);
    }

    public boolean relationshipDeletedInTransaction(long relationship) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() && this.txState().relationshipIsDeletedInThisTx(relationship);
    }

    public Value nodePropertyChangeInTransactionOrNull(long node, int propertyKeyId) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() ? this.txState().getNodeState(node).propertyValue(propertyKeyId) : null;
    }

    public long countsForNode(int labelId) {
        long count = this.countsForNodeWithoutTxState(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                TransactionState txState = this.ktx.txState();
                txState.accept((TxStateVisitor)new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, txState, counts));
                if (counts.hasChanges()) {
                    count += counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public long countsForNodeWithoutTxState(int labelId) {
        return this.storageReader.countsForNode(labelId);
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        long count = this.countsForRelationshipWithoutTxState(startLabelId, typeId, endLabelId);
        if (this.ktx.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                TransactionState txState = this.ktx.txState();
                txState.accept((TxStateVisitor)new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, txState, counts));
                if (counts.hasChanges()) {
                    count += counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        return this.storageReader.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    public boolean relationshipExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.relationshipIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.relationshipIsAddedInThisTx(reference)) {
                return true;
            }
        }
        return this.storageReader.relationshipExists(reference);
    }

    @Override
    long graphPropertiesReference() {
        return this.storageReader.getGraphPropertyReference();
    }

    @Override
    public IndexReader indexReader(IndexReference index, boolean fresh) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return fresh ? this.storageReader.getFreshIndexReader((IndexDescriptor)index) : this.storageReader.getIndexReader((IndexDescriptor)index);
    }

    @Override
    LabelScanReader labelScanReader() {
        return this.storageReader.getLabelScanReader();
    }

    @Override
    ExplicitIndex explicitNodeIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.explicitIndexTxState().nodeChanges(indexName);
    }

    @Override
    ExplicitIndex explicitRelationshipIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.explicitIndexTxState().relationshipChanges(indexName);
    }

    public String[] nodeExplicitIndexesGetAll() {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getAllNodeIndexNames();
    }

    public boolean nodeExplicitIndexExists(String indexName, Map<String, String> customConfiguration) {
        this.ktx.assertOpen();
        return this.explicitIndexTxState().checkIndexExistence(IndexEntityType.Node, indexName, customConfiguration);
    }

    public Map<String, String> nodeExplicitIndexGetConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getNodeIndexConfiguration(indexName);
    }

    public String[] relationshipExplicitIndexesGetAll() {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getAllRelationshipIndexNames();
    }

    public boolean relationshipExplicitIndexExists(String indexName, Map<String, String> customConfiguration) {
        this.ktx.assertOpen();
        return this.explicitIndexTxState().checkIndexExistence(IndexEntityType.Relationship, indexName, customConfiguration);
    }

    public Map<String, String> relationshipExplicitIndexGetConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getRelationshipIndexConfiguration(indexName);
    }

    @Override
    public IndexReference index(int label, int ... properties) {
        LabelSchemaDescriptor descriptor;
        this.ktx.assertOpen();
        try {
            descriptor = SchemaDescriptorFactory.forLabel(label, properties);
        }
        catch (IllegalArgumentException ignore) {
            return IndexReference.NO_INDEX;
        }
        CapableIndexDescriptor indexDescriptor = this.storageReader.indexGetForSchema((SchemaDescriptor)descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets diffSets = this.ktx.txState().indexDiffSetsByLabel(label);
            if (indexDescriptor != null) {
                if (diffSets.isRemoved((Object)indexDescriptor)) {
                    return IndexReference.NO_INDEX;
                }
                return indexDescriptor;
            }
            Iterator fromTxState = Iterators.filter((Predicate)SchemaDescriptor.equalTo((SchemaDescriptor)descriptor), diffSets.getAdded().iterator());
            if (fromTxState.hasNext()) {
                return (IndexReference)fromTxState.next();
            }
            return IndexReference.NO_INDEX;
        }
        return indexDescriptor != null ? indexDescriptor : IndexReference.NO_INDEX;
    }

    public IndexReference index(SchemaDescriptor schema) {
        this.ktx.assertOpen();
        CapableIndexDescriptor indexDescriptor = this.storageReader.indexGetForSchema(schema);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets diffSets = this.ktx.txState().indexDiffSetsBySchema(schema);
            if (indexDescriptor != null) {
                if (diffSets.isRemoved((Object)indexDescriptor)) {
                    return IndexReference.NO_INDEX;
                }
                return indexDescriptor;
            }
            Iterator fromTxState = Iterators.filter((Predicate)SchemaDescriptor.equalTo((SchemaDescriptor)schema), diffSets.getAdded().iterator());
            if (fromTxState.hasNext()) {
                return (IndexReference)fromTxState.next();
            }
            return IndexReference.NO_INDEX;
        }
        return indexDescriptor != null ? indexDescriptor : IndexReference.NO_INDEX;
    }

    public IndexReference indexReferenceUnchecked(int label, int ... properties) {
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel(label, properties), Optional.empty(), (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED);
    }

    public IndexReference indexReferenceUnchecked(SchemaDescriptor schema) {
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)schema, Optional.empty(), (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED);
    }

    public Iterator<IndexReference> indexesGetForLabel(int labelId) {
        this.acquireSharedLock(ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        Iterator iterator = this.storageReader.indexesGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            iterator = this.ktx.txState().indexDiffSetsByLabel(labelId).apply(iterator);
        }
        return iterator;
    }

    public IndexReference indexGetForName(String name) {
        this.ktx.assertOpen();
        CapableIndexDescriptor index = this.storageReader.indexGetForName(name);
        if (this.ktx.hasTxStateWithChanges()) {
            Predicate<IndexDescriptor> namePredicate = indexDescriptor -> {
                try {
                    return ((String)indexDescriptor.getUserSuppliedName().get()).equals(name);
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            };
            Iterator indexes = this.ktx.txState().indexChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)index));
            index = (IndexDescriptor)Iterators.singleOrNull((Iterator)indexes);
        }
        if (index == null) {
            return IndexReference.NO_INDEX;
        }
        this.acquireSharedSchemaLock(index.schema());
        return index;
    }

    public Iterator<IndexReference> indexesGetAll() {
        this.ktx.assertOpen();
        Iterator iterator = this.storageReader.indexesGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            iterator = this.ktx.txState().indexChanges().apply(this.storageReader.indexesGetAll());
        }
        return Iterators.map(indexDescriptor -> {
            this.acquireSharedSchemaLock(indexDescriptor.schema());
            return indexDescriptor;
        }, (Iterator)iterator);
    }

    public InternalIndexState indexGetState(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index.schema());
        this.ktx.assertOpen();
        return this.indexGetState((IndexDescriptor)index);
    }

    public PopulationProgress indexGetPopulationProgress(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index.schema());
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState((IndexDescriptor)index, (DiffSets<IndexDescriptor>)this.ktx.txState().indexDiffSetsBySchema(index.schema()))) {
            return PopulationProgress.NONE;
        }
        return this.storageReader.indexGetPopulationProgress(index.schema());
    }

    public Long indexGetOwningUniquenessConstraintId(IndexReference index) {
        this.acquireSharedSchemaLock(index.schema());
        this.ktx.assertOpen();
        if (index instanceof StoreIndexDescriptor) {
            return ((StoreIndexDescriptor)index).getOwningConstraint();
        }
        return null;
    }

    public long indexGetCommittedId(IndexReference index) throws SchemaRuleNotFoundException {
        this.acquireSharedSchemaLock(index.schema());
        this.ktx.assertOpen();
        if (index instanceof StoreIndexDescriptor) {
            return ((StoreIndexDescriptor)index).getId();
        }
        throw new SchemaRuleNotFoundException(SchemaRule.Kind.INDEX_RULE, index.schema());
    }

    public String indexGetFailure(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.storageReader.indexGetFailure(index.schema());
    }

    public double indexUniqueValuesSelectivity(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        SchemaDescriptor schema = index.schema();
        this.acquireSharedSchemaLock(schema);
        this.ktx.assertOpen();
        return this.storageReader.indexUniqueValuesPercentage(schema);
    }

    public long indexSize(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        SchemaDescriptor schema = index.schema();
        this.acquireSharedSchemaLock(schema);
        this.ktx.assertOpen();
        return this.storageReader.indexSize(schema);
    }

    public long nodesCountIndexed(IndexReference index, long nodeId, int propertyKeyId, Value value) throws KernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        IndexReader reader = this.storageReader.getIndexReader((IndexDescriptor)index);
        return reader.countIndexedNodes(nodeId, new int[]{propertyKeyId}, new Value[]{value});
    }

    public long nodesGetCount() {
        this.ktx.assertOpen();
        long base = this.storageReader.nodesGetCount();
        return this.ktx.hasTxStateWithChanges() ? base + (long)this.ktx.txState().addedAndRemovedNodes().delta() : base;
    }

    public long relationshipsGetCount() {
        this.ktx.assertOpen();
        long base = this.storageReader.relationshipsGetCount();
        return this.ktx.hasTxStateWithChanges() ? base + (long)this.ktx.txState().addedAndRemovedRelationships().delta() : base;
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(IndexReference index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        return this.storageReader.indexUpdatesAndSize(index.schema(), target);
    }

    public Register.DoubleLongRegister indexSample(IndexReference index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        return this.storageReader.indexSample(index.schema(), target);
    }

    IndexReference indexGetCapability(IndexDescriptor schemaIndexDescriptor) {
        try {
            return this.storageReader.indexReference(schemaIndexDescriptor);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException("Could not find capability for index " + schemaIndexDescriptor, e);
        }
    }

    InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState(descriptor, (DiffSets<IndexDescriptor>)this.ktx.txState().indexDiffSetsBySchema(descriptor.schema()))) {
            return InternalIndexState.POPULATING;
        }
        return this.storageReader.indexGetState(descriptor);
    }

    Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        return this.storageReader.indexGetOwningUniquenessConstraintId(index);
    }

    IndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        CapableIndexDescriptor indexDescriptor = this.storageReader.indexGetForSchema(descriptor);
        Iterator indexes = Iterators.iterator((Object)indexDescriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            indexes = Iterators.filter((Predicate)SchemaDescriptor.equalTo((SchemaDescriptor)descriptor), (Iterator)this.ktx.txState().indexDiffSetsBySchema(descriptor).apply(indexes));
        }
        return (IndexDescriptor)Iterators.singleOrNull((Iterator)indexes);
    }

    private boolean checkIndexState(IndexDescriptor index, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded((Object)index)) {
            return true;
        }
        if (diffSet.isRemoved((Object)index)) {
            throw new IndexNotFoundKernelException(String.format("Index on %s has been dropped in this transaction.", index.userDescription(SchemaUtil.idTokenNameLookup)));
        }
        return false;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        this.acquireSharedSchemaLock(descriptor);
        this.ktx.assertOpen();
        Iterator constraints = this.storageReader.constraintsGetForSchema(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForSchema(descriptor).apply(constraints);
        }
        return constraints;
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        SchemaDescriptor schema = descriptor.schema();
        this.acquireSharedSchemaLock(schema);
        this.ktx.assertOpen();
        boolean inStore = this.storageReader.constraintExists(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets diffSet = this.ktx.txState().constraintsChangesForSchema(descriptor.schema());
            return diffSet.isAdded((Object)descriptor) || inStore && !diffSet.isRemoved((Object)descriptor);
        }
        return inStore;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.acquireSharedLock(ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        Iterator constraints = this.storageReader.constraintsGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.ktx.assertOpen();
        Iterator constraints = this.storageReader.constraintsGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            constraints = this.ktx.txState().constraintsChanges().apply(constraints);
        }
        return Iterators.map(this::lockConstraint, (Iterator)constraints);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.acquireSharedLock(ResourceTypes.RELATIONSHIP_TYPE, typeId);
        this.ktx.assertOpen();
        Iterator constraints = this.storageReader.constraintsGetForRelationshipType(typeId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    boolean nodeExistsInStore(long id) {
        return this.storageReader.nodeExists(id);
    }

    void getOrCreateNodeIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    void getOrCreateRelationshipIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storageReader.indexGetFailure(descriptor.schema());
    }

    public UserFunctionHandle functionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.procedures.function(name);
    }

    public ProcedureHandle procedureGet(QualifiedName name) throws ProcedureException {
        this.ktx.assertOpen();
        return this.procedures.procedure(name);
    }

    public Set<ProcedureSignature> proceduresGetAll() {
        this.ktx.assertOpen();
        return this.procedures.getAllProcedures();
    }

    public UserFunctionHandle aggregationFunctionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.procedures.aggregationFunction(name);
    }

    public RawIterator<Object[], ProcedureException> procedureCallRead(int id, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsReads()) {
            throw accessMode.onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(int id, Object[] arguments) throws ProcedureException {
        return this.callProcedure(id, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public RawIterator<Object[], ProcedureException> procedureCallWrite(int id, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(int id, Object[] arguments) throws ProcedureException {
        return this.callProcedure(id, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchema(int id, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(int id, Object[] arguments) throws ProcedureException {
        return this.callProcedure(id, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    public RawIterator<Object[], ProcedureException> procedureCallRead(QualifiedName name, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsReads()) {
            throw accessMode.onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        return this.callProcedure(name, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public RawIterator<Object[], ProcedureException> procedureCallWrite(QualifiedName name, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        return this.callProcedure(name, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchema(QualifiedName name, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        return this.callProcedure(name, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    public AnyValue functionCall(int id, AnyValue[] arguments) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callFunction(id, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public AnyValue functionCall(QualifiedName name, AnyValue[] arguments) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callFunction(name, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public AnyValue functionCallOverride(int id, AnyValue[] arguments) throws ProcedureException {
        return this.callFunction(id, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public AnyValue functionCallOverride(QualifiedName name, AnyValue[] arguments) throws ProcedureException {
        return this.callFunction(name, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunction(int id) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.aggregationFunction(id, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunction(QualifiedName name) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.aggregationFunction(name, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunctionOverride(int id) throws ProcedureException {
        return this.aggregationFunction(id, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunctionOverride(QualifiedName name) throws ProcedureException {
        return this.aggregationFunction(name, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public ValueMapper<Object> valueMapper() {
        return this.procedures.valueMapper();
    }

    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return this.schemaState.getOrCreate(key, creator);
    }

    public void schemaStateFlush() {
        this.schemaState.clear();
    }

    ExplicitIndexStore explicitIndexStore() {
        return this.explicitIndexStore;
    }

    private RawIterator<Object[], ProcedureException> callProcedure(int id, Object[] input, AccessMode override) throws ProcedureException {
        RawIterator<Object[], ProcedureException> procedureCall;
        this.ktx.assertOpen();
        SecurityContext procedureSecurityContext = this.ktx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
             KernelStatement statement = this.ktx.acquireStatement();){
            procedureCall = this.procedures.callProcedure((Context)this.prepareContext(procedureSecurityContext), id, input, (ResourceTracker)statement);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    private RawIterator<Object[], ProcedureException> callProcedure(QualifiedName name, Object[] input, AccessMode override) throws ProcedureException {
        RawIterator<Object[], ProcedureException> procedureCall;
        this.ktx.assertOpen();
        SecurityContext procedureSecurityContext = this.ktx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
             KernelStatement statement = this.ktx.acquireStatement();){
            procedureCall = this.procedures.callProcedure((Context)this.prepareContext(procedureSecurityContext), name, input, (ResourceTracker)statement);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    private RawIterator<Object[], ProcedureException> createIterator(final SecurityContext procedureSecurityContext, final RawIterator<Object[], ProcedureException> procedureCall) {
        return new RawIterator<Object[], ProcedureException>(){

            public boolean hasNext() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = AllStoreHolder.this.ktx.overrideWith(procedureSecurityContext);){
                    boolean bl = procedureCall.hasNext();
                    return bl;
                }
            }

            public Object[] next() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = AllStoreHolder.this.ktx.overrideWith(procedureSecurityContext);){
                    Object[] objectArray = (Object[])procedureCall.next();
                    return objectArray;
                }
            }
        };
    }

    private AnyValue callFunction(int id, AnyValue[] input, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            AnyValue anyValue = this.procedures.callFunction((Context)this.prepareContext(securityContext), id, input);
            return anyValue;
        }
    }

    private AnyValue callFunction(QualifiedName name, AnyValue[] input, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            AnyValue anyValue = this.procedures.callFunction((Context)this.prepareContext(securityContext), name, input);
            return anyValue;
        }
    }

    private UserAggregator aggregationFunction(int id, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            UserAggregator userAggregator = this.procedures.createAggregationFunction((Context)this.prepareContext(securityContext), id);
            return userAggregator;
        }
    }

    private UserAggregator aggregationFunction(QualifiedName name, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            UserAggregator userAggregator = this.procedures.createAggregationFunction((Context)this.prepareContext(securityContext), name);
            return userAggregator;
        }
    }

    private BasicContext prepareContext(SecurityContext securityContext) {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, this.ktx);
        ctx.put(Context.DATABASE_API, this.dataSourceDependencies.resolveDependency(GraphDatabaseAPI.class));
        ctx.put(Context.DEPENDENCY_RESOLVER, this.dataSourceDependencies);
        ctx.put(Context.THREAD, Thread.currentThread());
        ClockContext clocks = this.ktx.clocks();
        ctx.put(Context.SYSTEM_CLOCK, clocks.systemClock());
        ctx.put(Context.STATEMENT_CLOCK, clocks.statementClock());
        ctx.put(Context.TRANSACTION_CLOCK, clocks.transactionClock());
        ctx.put(Context.SECURITY_CONTEXT, securityContext);
        return ctx;
    }

    private static void assertValidIndex(IndexReference index) throws IndexNotFoundKernelException {
        if (index == IndexReference.NO_INDEX) {
            throw new IndexNotFoundKernelException("No index was found");
        }
    }

    private ConstraintDescriptor lockConstraint(ConstraintDescriptor constraint) {
        SchemaDescriptor schema = constraint.schema();
        this.ktx.statementLocks().pessimistic().acquireShared(this.ktx.lockTracer(), schema.keyType(), schema.keyId());
        return constraint;
    }
}

