/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Collection;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public interface IndexPopulator {
    public static final IndexPopulator EMPTY = new Adapter();

    public void create();

    public void drop();

    public void add(Collection<? extends IndexEntryUpdate<?>> var1) throws IndexEntryConflictException;

    public void verifyDeferredConstraints(NodePropertyAccessor var1) throws IndexEntryConflictException;

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor var1);

    public void close(boolean var1);

    public void markAsFailed(String var1);

    public void includeSample(IndexEntryUpdate<?> var1);

    public IndexSample sampleResult();

    default public PopulationProgress progress(PopulationProgress scanProgress) {
        return scanProgress;
    }

    default public void scanCompleted(PhaseTracker phaseTracker) throws IndexEntryConflictException {
    }

    public static class Adapter
    implements IndexPopulator {
        @Override
        public void create() {
        }

        @Override
        public void drop() {
        }

        @Override
        public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
        }

        @Override
        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void scanCompleted(PhaseTracker phaseTracker) {
        }

        @Override
        public void close(boolean populationCompletedSuccessfully) {
        }

        @Override
        public void markAsFailed(String failure) {
        }

        @Override
        public void includeSample(IndexEntryUpdate<?> update) {
        }

        @Override
        public IndexSample sampleResult() {
            return new IndexSample();
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        }
    }
}

