/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.NativeMemoryAllocationRefusedError;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.util.Preconditions;

public class UnsafeDirectByteBufferFactory
implements ByteBufferFactory {
    private final MemoryAllocationTracker memoryAllocationTracker;
    private final List<Allocation> allocations = new ArrayList<Allocation>();
    private boolean closed;

    UnsafeDirectByteBufferFactory(MemoryAllocationTracker memoryAllocationTracker) {
        this.memoryAllocationTracker = memoryAllocationTracker;
    }

    @Override
    public synchronized ByteBuffer newBuffer(int bufferSize) {
        this.assertOpen();
        try {
            long address = UnsafeUtil.allocateMemory((long)bufferSize, (MemoryAllocationTracker)this.memoryAllocationTracker);
            try {
                ByteBuffer buffer = UnsafeUtil.newDirectByteBuffer((long)address, (int)bufferSize);
                UnsafeUtil.initDirectByteBuffer((Object)buffer, (long)address, (int)bufferSize);
                this.allocations.add(new Allocation(address, bufferSize));
                return buffer;
            }
            catch (Exception e) {
                UnsafeUtil.free((long)address, (long)bufferSize, (MemoryAllocationTracker)this.memoryAllocationTracker);
                return this.allocateHeapBuffer(bufferSize);
            }
        }
        catch (NativeMemoryAllocationRefusedError allocationRefusedError) {
            return this.allocateHeapBuffer(bufferSize);
        }
    }

    private ByteBuffer allocateHeapBuffer(int bufferSize) {
        return ByteBuffer.allocate(bufferSize);
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.allocations.forEach(allocation -> UnsafeUtil.free((long)((Allocation)allocation).address, (long)((Allocation)allocation).bytes, (MemoryAllocationTracker)this.memoryAllocationTracker));
            this.closed = true;
        }
    }

    private void assertOpen() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Already closed");
    }

    private static class Allocation {
        private final long address;
        private final int bytes;

        Allocation(long address, int bytes) {
            this.address = address;
            this.bytes = bytes;
        }
    }
}

