/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.kernel.impl.index.schema.SpatialIndexAccessor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.ValueCategory;

public class SpatialIndexProvider
extends IndexProvider {
    public static final String KEY = "spatial";
    static final IndexCapability CAPABILITY = new SpatialIndexCapability();
    private static final IndexProviderDescriptor SPATIAL_PROVIDER_DESCRIPTOR = new IndexProviderDescriptor("spatial", "1.0");
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final IndexProvider.Monitor monitor;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final boolean readOnly;
    private final SpaceFillingCurveConfiguration configuration;
    private final ConfiguredSpaceFillingCurveSettingsCache configuredSettings;

    public SpatialIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, Config config) {
        super(SPATIAL_PROVIDER_DESCRIPTOR, directoryStructure);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
        this.configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration(config);
        this.configuredSettings = this.getConfiguredSpaceFillingCurveSettings(config);
    }

    private ConfiguredSpaceFillingCurveSettingsCache getConfiguredSpaceFillingCurveSettings(Config config) {
        return new ConfiguredSpaceFillingCurveSettingsCache(config);
    }

    @Override
    public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        SpatialIndexFiles files = new SpatialIndexFiles(this.directoryStructure(), descriptor.getId(), this.fs, this.configuredSettings);
        return new SpatialIndexPopulator(descriptor, files, this.pageCache, this.fs, this.monitor, this.configuration);
    }

    @Override
    public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        SpatialIndexFiles files = new SpatialIndexFiles(this.directoryStructure(), descriptor.getId(), this.fs, this.configuredSettings);
        return new SpatialIndexAccessor(descriptor, this.pageCache, this.fs, this.recoveryCleanupWorkCollector, this.monitor, files, this.configuration);
    }

    @Override
    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        SpatialIndexFiles spatialIndexFiles = new SpatialIndexFiles(this.directoryStructure(), descriptor.getId(), this.fs, this.configuredSettings);
        try {
            for (SpatialIndexFiles.SpatialFile subIndex : spatialIndexFiles.existing()) {
                String indexFailure = NativeIndexes.readFailureMessage(this.pageCache, subIndex.indexFile);
                if (indexFailure == null) continue;
                return indexFailure;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Index " + descriptor.getId() + " isn't failed");
    }

    @Override
    public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
        SpatialIndexFiles spatialIndexFiles = new SpatialIndexFiles(this.directoryStructure(), descriptor.getId(), this.fs, this.configuredSettings);
        Iterable<SpatialIndexFiles.SpatialFile> existing = spatialIndexFiles.existing();
        InternalIndexState state = InternalIndexState.ONLINE;
        for (SpatialIndexFiles.SpatialFile subIndex : existing) {
            try {
                switch (NativeIndexes.readState(this.pageCache, subIndex.indexFile)) {
                    case FAILED: {
                        return InternalIndexState.FAILED;
                    }
                    case POPULATING: {
                        state = InternalIndexState.POPULATING;
                    }
                }
            }
            catch (IOException | MetadataMismatchException e) {
                this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
                return InternalIndexState.POPULATING;
            }
        }
        return state;
    }

    @Override
    public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
        return CAPABILITY;
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private static class SpatialIndexCapability
    implements IndexCapability {
        private SpatialIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            return ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.NO;
        }

        public boolean isFulltextIndex() {
            return false;
        }

        public boolean isEventuallyConsistent() {
            return false;
        }
    }
}

