/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

class CountCommittedTransactionThreshold
extends AbstractCheckPointThreshold {
    private final int notificationThreshold;
    private volatile long nextTransactionIdTarget;

    CountCommittedTransactionThreshold(int notificationThreshold) {
        super("tx count threshold");
        this.notificationThreshold = notificationThreshold;
    }

    @Override
    public void initialize(long transactionId) {
        this.nextTransactionIdTarget = transactionId + (long)this.notificationThreshold;
    }

    @Override
    protected boolean thresholdReached(long lastCommittedTransactionId, long lastCommittedTransactionLogVersion) {
        return lastCommittedTransactionId >= this.nextTransactionIdTarget;
    }

    @Override
    public void checkPointHappened(long transactionId) {
        this.nextTransactionIdTarget = transactionId + (long)this.notificationThreshold;
    }

    @Override
    public long checkFrequencyMillis() {
        return DEFAULT_CHECKING_FREQUENCY_MILLIS;
    }
}

