/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

import java.net.SocketAddress;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

public class BoltConnectionInfo
extends ClientConnectionInfo {
    private final String connectionId;
    private final String principalName;
    private final String clientName;
    private final SocketAddress clientAddress;
    private final SocketAddress serverAddress;

    public BoltConnectionInfo(String connectionId, String principalName, String clientName, SocketAddress clientAddress, SocketAddress serverAddress) {
        this.connectionId = connectionId;
        this.principalName = principalName;
        this.clientName = clientName;
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
    }

    @Override
    public String asConnectionDetails() {
        return String.format("bolt-session\tbolt\t%s\t%s\t\tclient%s\tserver%s>", this.principalName, this.clientName, this.clientAddress, this.serverAddress);
    }

    @Override
    public String protocol() {
        return "bolt";
    }

    @Override
    public String connectionId() {
        return this.connectionId;
    }

    @Override
    public String clientAddress() {
        return org.neo4j.helpers.SocketAddress.format(this.clientAddress);
    }

    @Override
    public String requestURI() {
        return org.neo4j.helpers.SocketAddress.format(this.serverAddress);
    }
}

