/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Objects;
import org.neo4j.helpers.collection.Iterators;

public class SocketAddress {
    private static final Collection<String> WILDCARDS = Iterators.asSet((Object[])new String[]{"0.0.0.0", "::"});
    private final String hostname;
    private final int port;

    public SocketAddress(String hostname, int port) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        if (hostname.contains("[") || hostname.contains("]")) {
            throw new IllegalArgumentException("hostname cannot contain '[' or ']'");
        }
        this.hostname = hostname;
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress socketAddress() {
        return new InetSocketAddress(this.hostname, this.port);
    }

    public boolean isWildcard() {
        return WILDCARDS.contains(this.hostname);
    }

    public boolean isIPv6() {
        return SocketAddress.isIPv6(this.hostname);
    }

    public String toString() {
        return SocketAddress.format(this.hostname, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketAddress that = (SocketAddress)o;
        return this.port == that.port && Objects.equals(this.hostname, that.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.port);
    }

    public static String format(java.net.SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            return SocketAddress.format(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        }
        return address == null ? "" : address.toString();
    }

    public static String format(String hostname, int port) {
        return String.format(SocketAddress.isIPv6(hostname) ? "[%s]:%s" : "%s:%s", hostname, port);
    }

    private static boolean isIPv6(String hostname) {
        return hostname.contains(":");
    }
}

