/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.IOException;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.primitive.AbstractLongIterable;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.util.VisibleForTesting;

abstract class AbstractLinearProbeLongHashSet
extends AbstractLongIterable
implements LongSet {
    private static final long EMPTY = 0L;
    static final long REMOVED = 1L;
    Memory memory;
    int capacity;
    int elementsInMemory;
    long modCount;
    boolean hasZero;
    boolean hasOne;

    AbstractLinearProbeLongHashSet() {
    }

    AbstractLinearProbeLongHashSet(AbstractLinearProbeLongHashSet src) {
        this.memory = src.memory;
        this.capacity = src.capacity;
        this.hasZero = src.hasZero;
        this.hasOne = src.hasOne;
        this.elementsInMemory = src.elementsInMemory;
    }

    public LongIterator longIterator() {
        return new FailFastIterator();
    }

    public long[] toArray() {
        MutableInt idx = new MutableInt();
        long[] array = new long[this.size()];
        this.each((LongProcedure & Serializable)element -> {
            array[idx.getAndIncrement()] = element;
        });
        return array;
    }

    public boolean contains(long element) {
        if (element == 0L) {
            return this.hasZero;
        }
        if (element == 1L) {
            return this.hasOne;
        }
        int idx = this.indexOf(element);
        return this.valueAt(idx) == element;
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        if (this.hasZero) {
            procedure.accept(0L);
        }
        if (this.hasOne) {
            procedure.accept(1L);
        }
        int visited = 0;
        for (int i = 0; i < this.capacity && visited < this.elementsInMemory; ++i) {
            long value = this.valueAt(i);
            if (!AbstractLinearProbeLongHashSet.isRealValue(value)) continue;
            procedure.accept(value);
            ++visited;
        }
    }

    public boolean anySatisfy(LongPredicate predicate) {
        if (this.hasZero && predicate.test(0L) || this.hasOne && predicate.test(1L)) {
            return true;
        }
        int visited = 0;
        for (int i = 0; i < this.capacity && visited < this.elementsInMemory; ++i) {
            long value = this.valueAt(i);
            if (!AbstractLinearProbeLongHashSet.isRealValue(value)) continue;
            if (predicate.test(value)) {
                return true;
            }
            ++visited;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        if (this.hasZero && !predicate.test(0L) || this.hasOne && !predicate.test(1L)) {
            return false;
        }
        int visited = 0;
        for (int i = 0; i < this.capacity && visited < this.elementsInMemory; ++i) {
            long value = this.valueAt(i);
            if (!AbstractLinearProbeLongHashSet.isRealValue(value)) continue;
            if (!predicate.test(value)) {
                return false;
            }
            ++visited;
        }
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        throw new UnsupportedOperationException();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException();
    }

    public int count(LongPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    public long sum() {
        throw new UnsupportedOperationException();
    }

    public long max() {
        throw new UnsupportedOperationException();
    }

    public long min() {
        throw new UnsupportedOperationException();
    }

    public MutableLongSet select(LongPredicate predicate) {
        return (MutableLongSet)this.select(predicate, (MutableLongCollection)new LongHashSet());
    }

    public MutableLongSet reject(LongPredicate predicate) {
        return (MutableLongSet)this.reject(predicate, (MutableLongCollection)new LongHashSet());
    }

    public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        UnifiedSet result = new UnifiedSet(this.size());
        this.each(arg_0 -> AbstractLinearProbeLongHashSet.lambda$collect$dee3c696$1((MutableSet)result, function, arg_0));
        return result;
    }

    public int hashCode() {
        MutableInt h = new MutableInt();
        this.each((LongProcedure & Serializable)element -> h.add((int)(element ^ element >>> 32)));
        return h.intValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongSet)) {
            return false;
        }
        LongSet other = (LongSet)obj;
        return this.size() == other.size() && this.containsAll((LongIterable)other);
    }

    public int size() {
        return this.elementsInMemory + (this.hasZero ? 1 : 0) + (this.hasOne ? 1 : 0);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append("offheap,size=").append(String.valueOf(this.size())).append("; ");
            LongIterator iterator = this.longIterator();
            for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
                appendable.append(Long.toString(iterator.next()));
                if (!iterator.hasNext()) continue;
                appendable.append(", ");
            }
            if (iterator.hasNext()) {
                appendable.append("...");
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isRealValue(long value) {
        return value != 1L && value != 0L;
    }

    @VisibleForTesting
    int hashAndMask(long element) {
        long h = SpreadFunctions.longSpreadOne((long)element);
        return Long.hashCode(h) & this.capacity - 1;
    }

    long valueAt(int idx) {
        return this.memory.readLong((long)idx * 8L);
    }

    int indexOf(long element) {
        int idx = this.hashAndMask(element);
        int firstRemovedIdx = -1;
        for (int i = 0; i < this.capacity; ++i) {
            long valueAtIdx = this.valueAt(idx);
            if (valueAtIdx == element) {
                return idx;
            }
            if (valueAtIdx == 0L) {
                return firstRemovedIdx == -1 ? idx : firstRemovedIdx;
            }
            if (valueAtIdx == 1L && firstRemovedIdx == -1) {
                firstRemovedIdx = idx;
            }
            idx = idx + 1 & this.capacity - 1;
        }
        throw new AssertionError((Object)("Failed to determine index for " + element));
    }

    private static /* synthetic */ void lambda$collect$dee3c696$1(MutableSet result, LongToObjectFunction function, long element) {
        result.add(function.apply(element));
    }

    class FailFastIterator
    implements MutableLongIterator {
        private final long modCount;
        private int visited;
        private int idx;
        private boolean handledZero;
        private boolean handledOne;

        FailFastIterator() {
            this.modCount = AbstractLinearProbeLongHashSet.this.modCount;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public long next() {
            long value;
            if (!this.hasNext()) {
                throw new NoSuchElementException("iterator is exhausted");
            }
            ++this.visited;
            if (!this.handledZero) {
                this.handledZero = true;
                if (AbstractLinearProbeLongHashSet.this.hasZero) {
                    return 0L;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (AbstractLinearProbeLongHashSet.this.hasOne) {
                    return 1L;
                }
            }
            while (!AbstractLinearProbeLongHashSet.isRealValue(value = AbstractLinearProbeLongHashSet.this.valueAt(this.idx++))) {
            }
            return value;
        }

        public boolean hasNext() {
            this.checkState();
            return this.visited < AbstractLinearProbeLongHashSet.this.size();
        }

        private void checkState() {
            if (this.modCount != AbstractLinearProbeLongHashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

