/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneOffset;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class ZonedTimeIndexKey
extends NativeIndexSingleValueKey<ZonedTimeIndexKey> {
    static final int SIZE = 20;
    long nanosOfDayUTC;
    int zoneOffsetSeconds;

    ZonedTimeIndexKey() {
    }

    @Override
    public Value asValue() {
        if (TimeZones.validZoneOffset((int)this.zoneOffsetSeconds)) {
            return TimeValue.time((long)this.nanosOfDayUTC, (ZoneOffset)ZoneOffset.ofTotalSeconds(this.zoneOffsetSeconds));
        }
        return Values.NO_VALUE;
    }

    @Override
    public void initValueAsLowest(ValueGroup valueGroups) {
        this.nanosOfDayUTC = Long.MIN_VALUE;
        this.zoneOffsetSeconds = Integer.MIN_VALUE;
    }

    @Override
    public void initValueAsHighest(ValueGroup valueGroups) {
        this.nanosOfDayUTC = Long.MAX_VALUE;
        this.zoneOffsetSeconds = Integer.MAX_VALUE;
    }

    @Override
    public int compareValueTo(ZonedTimeIndexKey other) {
        int compare = Long.compare(this.nanosOfDayUTC, other.nanosOfDayUTC);
        if (compare == 0) {
            compare = Integer.compare(this.zoneOffsetSeconds, other.zoneOffsetSeconds);
        }
        return compare;
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,nanosOfDayUTC=%d,zoneOffsetSeconds=%d", this.asValue(), this.getEntityId(), this.nanosOfDayUTC, this.zoneOffsetSeconds);
    }

    @Override
    public void writeTime(long nanosOfDayUTC, int offsetSeconds) {
        this.nanosOfDayUTC = nanosOfDayUTC;
        this.zoneOffsetSeconds = offsetSeconds;
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!(value instanceof TimeValue)) {
            throw new IllegalArgumentException("Key layout does only support TimeValue, tried to create key from " + value);
        }
        return value;
    }
}

