/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.util.stream.Stream;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.Log;

public class JvmChecker {
    public static final String INCOMPATIBLE_JVM_WARNING = "You are using an unsupported Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8 or 11, OpenJDK(TM) 8 or 11 or IBM J9.";
    public static final String INCOMPATIBLE_JVM_VERSION_WARNING = "You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8 or 11, OpenJDK(TM) 8 or 11 or IBM J9.";
    public static final String NO_SERIALIZATION_FILTER_WARNING = "The version of the Java runtime you are using  does not include some important security features. Please use a JRE of version 8u121 or higher.";
    private final Log log;
    private final JvmMetadataRepository jvmMetadataRepository;

    public JvmChecker(Log log, JvmMetadataRepository jvmMetadataRepository) {
        this.log = log;
        this.jvmMetadataRepository = jvmMetadataRepository;
    }

    public void checkJvmCompatibilityAndIssueWarning() {
        String javaVmName = this.jvmMetadataRepository.getJavaVmName();
        String javaVersion = this.jvmMetadataRepository.getJavaVersion();
        if (!javaVmName.matches("(Java HotSpot\\(TM\\)|OpenJDK|IBM) (64-Bit Server|Server|Client|J9) VM")) {
            this.log.warn(INCOMPATIBLE_JVM_WARNING);
        } else if (!javaVersion.matches("^(1\\.[8]|11).*")) {
            this.log.warn(INCOMPATIBLE_JVM_VERSION_WARNING);
        }
        if (!this.serializationFilterIsAvailable()) {
            this.log.warn(NO_SERIALIZATION_FILTER_WARNING);
        }
    }

    public boolean serializationFilterIsAvailable() {
        Stream<String> classNames = Stream.of("sun.misc.ObjectInputFilter", "java.io.ObjectInputFilter");
        return classNames.anyMatch(className -> {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        });
    }
}

