/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;

public class StoreViewNodeStoreScan<FAILURE extends Exception>
extends PropertyAwareEntityStoreScan<StorageNodeCursor, FAILURE> {
    private final Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor;
    private final Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor;
    protected final int[] labelIds;

    public StoreViewNodeStoreScan(StorageReader storageReader, LockService locks, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter) {
        super(storageReader, storageReader.nodesGetCount(), propertyKeyIdFilter, id -> locks.acquireNodeLock(id, LockService.LockType.READ_LOCK));
        this.labelUpdateVisitor = labelUpdateVisitor;
        this.propertyUpdatesVisitor = propertyUpdatesVisitor;
        this.labelIds = labelIds;
    }

    @Override
    protected StorageNodeCursor allocateCursor(StorageReader storageReader) {
        return storageReader.allocateNodeCursor();
    }

    @Override
    public boolean process(StorageNodeCursor cursor) throws FAILURE {
        EntityUpdates.Builder updates;
        long[] labels = cursor.labels();
        if (labels.length == 0 && this.labelIds.length != 0) {
            return false;
        }
        if (this.labelUpdateVisitor != null) {
            this.labelUpdateVisitor.visit((Object)NodeLabelUpdate.labelChanges(cursor.entityReference(), PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels));
        }
        if (this.propertyUpdatesVisitor != null && StoreViewNodeStoreScan.containsAnyEntityToken(this.labelIds, labels) && this.hasRelevantProperty(cursor, updates = EntityUpdates.forEntity(cursor.entityReference(), true).withTokens(labels))) {
            return this.propertyUpdatesVisitor.visit((Object)updates.build());
        }
        return false;
    }
}

