/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.SimpleEntryStorage;

class IndexKeyStorage<KEY extends NativeIndexKey<KEY>>
extends SimpleEntryStorage<KEY, KeyEntryCursor<KEY>> {
    private static final byte KEY_TYPE = 1;
    private final Layout<KEY, ?> layout;

    IndexKeyStorage(FileSystemAbstraction fs, File file, ByteBufferFactory.Allocator byteBufferFactory, int blockSize, Layout<KEY, ?> layout) throws IOException {
        super(fs, file, byteBufferFactory, blockSize);
        this.layout = layout;
    }

    @Override
    void add(KEY key, PageCursor pageCursor) throws IOException {
        int entrySize = 1 + BlockEntry.keySize(this.layout, key);
        this.prepareWrite(entrySize);
        pageCursor.putByte((byte)1);
        BlockEntry.write(pageCursor, this.layout, key);
    }

    @Override
    KeyEntryCursor<KEY> reader(PageCursor pageCursor) {
        return new KeyEntryCursor<KEY>(pageCursor, this.layout);
    }

    static class KeyEntryCursor<KEY>
    implements BlockEntryCursor<KEY, Void> {
        private final PageCursor pageCursor;
        private final Layout<KEY, ?> layout;
        private final KEY key;

        KeyEntryCursor(PageCursor pageCursor, Layout<KEY, ?> layout) {
            this.pageCursor = pageCursor;
            this.layout = layout;
            this.key = layout.newKey();
        }

        @Override
        public boolean next() throws IOException {
            byte type = this.pageCursor.getByte();
            if (type == -1) {
                return false;
            }
            if (type != 1) {
                throw new RuntimeException(String.format("Unexpected entry type. Expected %d or %d, but was %d.", (byte)-1, (byte)1, type));
            }
            BlockEntry.read(this.pageCursor, this.layout, this.key);
            return true;
        }

        @Override
        public KEY key() {
            return this.key;
        }

        @Override
        public Void value() {
            return null;
        }

        @Override
        public void close() throws IOException {
            this.pageCursor.close();
        }
    }
}

