/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyDeleter;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.DataImporter;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class DeleteDuplicateNodesStep
extends LonelyProcessingStep {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final LongIterator nodeIds;
    private final DataImporter.Monitor storeMonitor;
    private long nodesRemoved;
    private long propertiesRemoved;

    public DeleteDuplicateNodesStep(StageControl control, Configuration config, LongIterator nodeIds, NodeStore nodeStore, PropertyStore propertyStore, DataImporter.Monitor storeMonitor) {
        super(control, "DEDUP", config, new StatsProvider[0]);
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.nodeIds = nodeIds;
        this.storeMonitor = storeMonitor;
    }

    @Override
    protected void process() {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        PropertyRecord propertyRecord = this.propertyStore.newRecord();
        try (PageCursor cursor = this.nodeStore.openPageCursorForReading(0L);
             PageCursor propertyCursor = this.propertyStore.openPageCursorForReading(0L);){
            while (this.nodeIds.hasNext()) {
                long duplicateNodeId = this.nodeIds.next();
                this.nodeStore.getRecordByCursor(duplicateNodeId, nodeRecord, RecordLoad.NORMAL, cursor);
                assert (nodeRecord.inUse()) : nodeRecord;
                this.nodeStore.ensureHeavy(nodeRecord);
                long nextProp = nodeRecord.getNextProp();
                while (!Record.NULL_REFERENCE.is(nextProp)) {
                    this.propertyStore.getRecordByCursor(nextProp, propertyRecord, RecordLoad.NORMAL, propertyCursor);
                    assert (propertyRecord.inUse()) : propertyRecord + " for " + nodeRecord;
                    this.propertyStore.ensureHeavy(propertyRecord);
                    this.propertiesRemoved += (long)propertyRecord.numberOfProperties();
                    nextProp = propertyRecord.getNextProp();
                    PropertyDeleter.deletePropertyRecordIncludingValueRecords(propertyRecord);
                    this.propertyStore.updateRecord(propertyRecord);
                }
                nodeRecord.setInUse(false);
                for (DynamicRecord labelRecord : nodeRecord.getDynamicLabelRecords()) {
                    labelRecord.setInUse(false);
                }
                this.nodeStore.updateRecord(nodeRecord);
                ++this.nodesRemoved;
            }
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.storeMonitor.nodesRemoved(this.nodesRemoved);
        this.storeMonitor.propertiesRemoved(this.propertiesRemoved);
    }
}

