/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.ReadAndDeleteTransactionConflictException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualValues;

public class RelationshipProxyWrappingValue
extends RelationshipValue {
    private final Relationship relationship;
    private volatile TextValue type;
    private volatile MapValue properties;
    private volatile NodeValue startNode;
    private volatile NodeValue endNode;

    RelationshipProxyWrappingValue(Relationship relationship) {
        super(relationship.getId());
        this.relationship = relationship;
    }

    public Relationship relationshipProxy() {
        return this.relationship;
    }

    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        MapValue p;
        RelationshipProxy proxy;
        if (this.relationship instanceof RelationshipProxy && !(proxy = (RelationshipProxy)this.relationship).initializeData()) {
            throw new ReadAndDeleteTransactionConflictException(RelationshipProxy.isDeletedInCurrentTransaction(this.relationship));
        }
        try {
            p = this.properties();
        }
        catch (NotFoundException e) {
            p = VirtualValues.EMPTY_MAP;
        }
        catch (IllegalStateException e) {
            throw new ReadAndDeleteTransactionConflictException(RelationshipProxy.isDeletedInCurrentTransaction(this.relationship), (Throwable)e);
        }
        if (this.id() < 0L) {
            writer.writeVirtualRelationshipHack((Object)this.relationship);
        }
        writer.writeRelationship(this.id(), this.startNode().id(), this.endNode().id(), this.type(), p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeValue startNode() {
        NodeValue start = this.startNode;
        if (start == null) {
            RelationshipProxyWrappingValue relationshipProxyWrappingValue = this;
            synchronized (relationshipProxyWrappingValue) {
                start = this.startNode;
                if (start == null) {
                    start = this.startNode = ValueUtils.fromNodeProxy(this.relationship.getStartNode());
                }
            }
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeValue endNode() {
        NodeValue end = this.endNode;
        if (end == null) {
            RelationshipProxyWrappingValue relationshipProxyWrappingValue = this;
            synchronized (relationshipProxyWrappingValue) {
                end = this.endNode;
                if (end == null) {
                    end = this.endNode = ValueUtils.fromNodeProxy(this.relationship.getEndNode());
                }
            }
        }
        return end;
    }

    public NodeValue otherNode(VirtualNodeValue node) {
        if (node instanceof NodeProxyWrappingNodeValue) {
            Node proxy = ((NodeProxyWrappingNodeValue)node).nodeProxy();
            return ValueUtils.fromNodeProxy(this.relationship.getOtherNode(proxy));
        }
        return super.otherNode(node);
    }

    public long otherNodeId(long node) {
        return this.relationship.getOtherNodeId(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextValue type() {
        TextValue t = this.type;
        if (t == null) {
            RelationshipProxyWrappingValue relationshipProxyWrappingValue = this;
            synchronized (relationshipProxyWrappingValue) {
                t = this.type;
                if (t == null) {
                    t = this.type = Values.stringValue((String)this.relationship.getType().name());
                }
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties() {
        MapValue m = this.properties;
        if (m == null) {
            RelationshipProxyWrappingValue relationshipProxyWrappingValue = this;
            synchronized (relationshipProxyWrappingValue) {
                m = this.properties;
                if (m == null) {
                    m = this.properties = ValueUtils.asMapValue(this.relationship.getAllProperties());
                }
            }
        }
        return m;
    }
}

