/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class SchemaRecord
extends AbstractBaseRecord
implements Iterable<DynamicRecord> {
    private Collection<DynamicRecord> records;

    public SchemaRecord(Collection<DynamicRecord> records) {
        super(-1L);
        this.initialize(records);
    }

    public SchemaRecord initialize(Collection<DynamicRecord> records) {
        this.initialize(true);
        Iterator<DynamicRecord> iterator = records.iterator();
        long id = iterator.hasNext() ? iterator.next().getId() : (long)Record.NULL_REFERENCE.intValue();
        this.setId(id);
        this.records = records;
        return this;
    }

    public void setDynamicRecords(Collection<DynamicRecord> records) {
        this.records.clear();
        this.records.addAll(records);
    }

    @Override
    public void clear() {
        super.clear();
        this.records = null;
    }

    @Override
    public Iterator<DynamicRecord> iterator() {
        return this.records.iterator();
    }

    public int size() {
        return this.records.size();
    }

    @Override
    public SchemaRecord clone() {
        SchemaRecord clone = (SchemaRecord)super.clone();
        ArrayList<DynamicRecord> list = new ArrayList<DynamicRecord>(this.records.size());
        for (DynamicRecord record : this.records) {
            list.add(record.clone());
        }
        clone.records = list;
        return clone;
    }
}

