/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;

public class NodeSchemaMatcher {
    private NodeSchemaMatcher() {
        throw new AssertionError((Object)"no instance");
    }

    static <SUPPLIER extends SchemaDescriptorSupplier, EXCEPTION extends Exception> void onMatchingSchema(Iterator<SUPPLIER> schemaSuppliers, int specialPropertyId, int[] existingPropertyIds, ThrowingConsumer<SUPPLIER, EXCEPTION> callback) throws EXCEPTION {
        assert (PrimitiveArrays.isSortedSet((int[])existingPropertyIds));
        while (schemaSuppliers.hasNext()) {
            SchemaDescriptorSupplier schemaSupplier = (SchemaDescriptorSupplier)schemaSuppliers.next();
            SchemaDescriptor schema = schemaSupplier.schema();
            if (!NodeSchemaMatcher.nodeHasSchemaProperties(existingPropertyIds, schema.getPropertyIds(), specialPropertyId)) continue;
            callback.accept((Object)schemaSupplier);
        }
    }

    static <SUPPLIER extends SchemaDescriptorSupplier, EXCEPTION extends Exception> void onMatchingSchema(Iterator<SUPPLIER> schemaSuppliers, long[] labels, int specialPropertyId, int[] existingPropertyIds, ThrowingConsumer<SUPPLIER, EXCEPTION> callback) throws EXCEPTION {
        assert (PrimitiveArrays.isSortedSet((int[])existingPropertyIds));
        assert (PrimitiveArrays.isSortedSet((long[])labels));
        while (schemaSuppliers.hasNext()) {
            SchemaDescriptorSupplier schemaSupplier = (SchemaDescriptorSupplier)schemaSuppliers.next();
            SchemaDescriptor schema = schemaSupplier.schema();
            if (!schema.isAffected(labels) || !NodeSchemaMatcher.nodeHasSchemaProperties(existingPropertyIds, schema.getPropertyIds(), specialPropertyId)) continue;
            callback.accept((Object)schemaSupplier);
        }
    }

    private static boolean nodeHasSchemaProperties(int[] existingPropertyIds, int[] indexPropertyIds, int changedPropertyId) {
        for (int indexPropertyId : indexPropertyIds) {
            if (indexPropertyId == changedPropertyId || NodeSchemaMatcher.contains(existingPropertyIds, indexPropertyId)) continue;
            return false;
        }
        return true;
    }

    private static boolean contains(int[] existingPropertyIds, int indexPropertyId) {
        return Arrays.binarySearch(existingPropertyIds, indexPropertyId) >= 0;
    }
}

