/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.config.SettingGroup;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;

public class SslPolicyConfigValidator
implements SettingGroup<Object> {
    public Map<String, String> validate(Map<String, String> params, Consumer<String> warningConsumer) throws InvalidSettingException {
        HashMap<String, String> validatedParams = new HashMap<String, String>();
        Set<String> validShortKeys = this.extractValidShortKeys();
        String groupSettingPrefix = this.groupPrefix();
        Pattern groupSettingPattern = Pattern.compile(Pattern.quote(groupSettingPrefix) + "\\.([^.]+)\\.?(.+)?");
        HashSet<String> policyNames = new HashSet<String>();
        for (Map.Entry<String, String> paramsEntry : params.entrySet()) {
            String settingName = paramsEntry.getKey();
            Matcher matcher = groupSettingPattern.matcher(settingName);
            if (!matcher.matches()) continue;
            policyNames.add(matcher.group(1));
            String shortKey = matcher.group(2);
            if (!validShortKeys.contains(shortKey)) {
                throw new InvalidSettingException("Invalid setting name: " + settingName);
            }
            validatedParams.put(settingName, paramsEntry.getValue());
        }
        for (String policyName : policyNames) {
            SslPolicyConfig policy = new SslPolicyConfig(policyName);
            if (params.containsKey(policy.base_directory.name())) continue;
            throw new InvalidSettingException("Missing mandatory setting: " + policy.base_directory.name());
        }
        return validatedParams;
    }

    private String groupPrefix() {
        return SslPolicyConfig.class.getDeclaredAnnotation(Group.class).value();
    }

    private Set<String> extractValidShortKeys() {
        Field[] fields;
        HashSet<String> validSettingNames = new HashSet<String>();
        String policyName = "example";
        int prefixLength = this.groupPrefix().length() + 1 + policyName.length() + 1;
        SslPolicyConfig examplePolicy = new SslPolicyConfig(policyName);
        for (Field field : fields = examplePolicy.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object obj = field.get(examplePolicy);
                if (!(obj instanceof Setting)) continue;
                String longKey = ((Setting)obj).name();
                String shortKey = longKey.substring(prefixLength);
                validSettingNames.add(shortKey);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return validSettingNames;
    }

    public Map<String, Object> values(Map<String, String> validConfig) {
        return Collections.emptyMap();
    }

    public List<Setting<Object>> settings(Map<String, String> params) {
        return Collections.emptyList();
    }

    public boolean deprecated() {
        return false;
    }

    public Optional<String> replacement() {
        return Optional.empty();
    }

    public boolean internal() {
        return false;
    }

    public boolean secret() {
        return false;
    }

    public Optional<String> documentedDefaultValue() {
        return Optional.empty();
    }

    public String valueDescription() {
        return "SSL policy configuration";
    }

    public Optional<String> description() {
        return Optional.empty();
    }

    public boolean dynamic() {
        return false;
    }
}

