/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.availability;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DescriptiveAvailabilityRequirement;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DatabaseAvailability
extends LifecycleAdapter {
    private static final AvailabilityRequirement AVAILABILITY_REQUIREMENT = new DescriptiveAvailabilityRequirement("Database available");
    private final AvailabilityGuard databaseAvailabilityGuard;
    private final TransactionCounters transactionCounters;
    private final Clock clock;
    private final long awaitActiveTransactionDeadlineMillis;
    private volatile boolean started;

    public DatabaseAvailability(AvailabilityGuard databaseAvailabilityGuard, TransactionCounters transactionCounters, Clock clock, long awaitActiveTransactionDeadlineMillis) {
        this.databaseAvailabilityGuard = databaseAvailabilityGuard;
        this.transactionCounters = transactionCounters;
        this.awaitActiveTransactionDeadlineMillis = awaitActiveTransactionDeadlineMillis;
        this.clock = clock;
        databaseAvailabilityGuard.require(AVAILABILITY_REQUIREMENT);
    }

    public void start() {
        this.databaseAvailabilityGuard.fulfill(AVAILABILITY_REQUIREMENT);
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.databaseAvailabilityGuard.require(AVAILABILITY_REQUIREMENT);
        this.awaitTransactionsClosedWithinTimeout();
    }

    public boolean isStarted() {
        return this.started;
    }

    private void awaitTransactionsClosedWithinTimeout() {
        long deadline = this.clock.millis() + this.awaitActiveTransactionDeadlineMillis;
        while (this.transactionCounters.getNumberOfActiveTransactions() > 0L && this.clock.millis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }
}

