/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Iterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.PopulationProgress;

class StorageSchemaReaderSnapshot
implements StorageSchemaReader {
    private final SchemaCache schema;
    private final RecordStorageReader reader;

    StorageSchemaReaderSnapshot(SchemaCache schema, RecordStorageReader reader) {
        this.schema = schema;
        this.reader = reader;
    }

    public CapableIndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        return this.schema.indexDescriptor(descriptor);
    }

    public Iterator<CapableIndexDescriptor> indexesGetForLabel(int labelId) {
        return this.schema.indexDescriptorsForLabel(labelId);
    }

    public Iterator<CapableIndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        return this.schema.indexDescriptorsForRelationshipType(relationshipType);
    }

    public Iterator<CapableIndexDescriptor> indexesGetAll() {
        return this.schema.indexDescriptors().iterator();
    }

    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.reader.indexGetState(descriptor);
    }

    public PopulationProgress indexGetPopulationProgress(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.reader.indexGetPopulationProgress(descriptor);
    }

    public String indexGetFailure(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.reader.indexGetFailure(descriptor);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.schema.constraintsForLabel(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.schema.constraintsForRelationshipType(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.schema.constraints();
    }
}

