/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.List;
import java.util.function.IntPredicate;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.core.TokenRegistry;

public abstract class AbstractTokenHolderBase
implements TokenHolder {
    protected final TokenRegistry tokenRegistry;

    public AbstractTokenHolderBase(TokenRegistry tokenRegistry) {
        this.tokenRegistry = tokenRegistry;
    }

    @Override
    public void setInitialTokens(List<NamedToken> tokens) throws NonUniqueTokenException {
        this.tokenRegistry.setInitialTokens(tokens);
    }

    @Override
    public void addToken(NamedToken token) throws NonUniqueTokenException {
        this.tokenRegistry.put(token);
    }

    @Override
    public int getOrCreateId(String name) {
        Integer id = this.tokenRegistry.getId(name);
        if (id != null) {
            return id;
        }
        try {
            return this.createToken(name);
        }
        catch (ReadOnlyDbException e) {
            throw new TransactionFailureException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (Throwable e) {
            throw new TransactionFailureException("Could not create token.", e);
        }
    }

    @Override
    public NamedToken getTokenById(int id) throws TokenNotFoundException {
        NamedToken result = this.tokenRegistry.getToken(id);
        if (result == null) {
            throw new TokenNotFoundException("Token for id " + id);
        }
        return result;
    }

    @Override
    public int getIdByName(String name) {
        Integer id = this.tokenRegistry.getId(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    @Override
    public boolean getIdsByNames(String[] names, int[] ids) {
        return this.resolveIds(names, ids, Predicates.ALWAYS_FALSE_INT);
    }

    @Override
    public Iterable<NamedToken> getAllTokens() {
        return this.tokenRegistry.allTokens();
    }

    @Override
    public int size() {
        return this.tokenRegistry.size();
    }

    protected abstract int createToken(String var1) throws KernelException;

    boolean resolveIds(String[] names, int[] ids, IntPredicate unresolvedIndexCheck) {
        boolean foundUnresolvable = false;
        for (int i = 0; i < ids.length; ++i) {
            Integer id = this.tokenRegistry.getId(names[i]);
            if (id != null) {
                ids[i] = id;
                continue;
            }
            foundUnresolvable = true;
            if (unresolvedIndexCheck.test(i)) break;
        }
        return foundUnresolvable;
    }
}

