/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.diagnostics;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Service;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;

public class DiagnosticsReporter {
    private final List<DiagnosticsOfflineReportProvider> providers = new ArrayList<DiagnosticsOfflineReportProvider>();
    private final Set<String> availableClassifiers = new TreeSet<String>();
    private final Map<String, List<DiagnosticsReportSource>> additionalSources = new HashMap<String, List<DiagnosticsReportSource>>();

    public void registerOfflineProvider(DiagnosticsOfflineReportProvider provider) {
        this.providers.add(provider);
        this.availableClassifiers.addAll(provider.getFilterClassifiers());
    }

    public void registerSource(String classifier, DiagnosticsReportSource source) {
        this.availableClassifiers.add(classifier);
        this.additionalSources.computeIfAbsent(classifier, c -> new ArrayList()).add(source);
    }

    public void dump(Set<String> classifiers, Path destination, DiagnosticsReporterProgress progress, boolean force) throws IOException {
        ArrayList<DiagnosticsReportSource> sources = new ArrayList<DiagnosticsReportSource>();
        for (DiagnosticsOfflineReportProvider diagnosticsOfflineReportProvider : this.providers) {
            sources.addAll(diagnosticsOfflineReportProvider.getDiagnosticsSources(classifiers));
        }
        for (Map.Entry entry : this.additionalSources.entrySet()) {
            if (!classifiers.contains("all") && !classifiers.contains(entry.getKey())) continue;
            sources.addAll((Collection)entry.getValue());
        }
        Path destinationFolder = destination.getParent();
        Files.createDirectories(destinationFolder, new FileAttribute[0]);
        this.estimateSizeAndCheckAvailableDiskSpace(destination, progress, sources, destinationFolder, force);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("create", "true");
        hashMap.put("useTempFile", Boolean.TRUE);
        URI uri = URI.create("jar:file:" + destination.toAbsolutePath().toUri().getRawPath());
        try (FileSystem fs = FileSystems.newFileSystem(uri, hashMap);){
            progress.setTotalSteps(sources.size());
            for (int i = 0; i < sources.size(); ++i) {
                DiagnosticsReportSource source = (DiagnosticsReportSource)sources.get(i);
                Path path = fs.getPath(source.destinationPath(), new String[0]);
                if (path.getParent() != null) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                progress.started(i + 1, path.toString());
                try {
                    source.addToArchive(path, progress);
                }
                catch (Throwable e) {
                    progress.error("Step failed", e);
                    continue;
                }
                progress.finished();
            }
        }
    }

    private void estimateSizeAndCheckAvailableDiskSpace(Path destination, DiagnosticsReporterProgress progress, List<DiagnosticsReportSource> sources, Path destinationFolder, boolean force) throws IOException {
        if (force) {
            return;
        }
        long estimatedFinalSize = 0L;
        for (DiagnosticsReportSource source : sources) {
            estimatedFinalSize += source.estimatedSize(progress);
        }
        long freeSpace = destinationFolder.toFile().getFreeSpace();
        if (estimatedFinalSize > freeSpace) {
            String message = String.format("Free available disk space for %s is %s, worst case estimate is %s. To ignore add '--force' to the command.", destination.getFileName(), Format.bytes(freeSpace), Format.bytes(estimatedFinalSize));
            throw new RuntimeException(message);
        }
    }

    public Set<String> getAvailableClassifiers() {
        return this.availableClassifiers;
    }

    public void registerAllOfflineProviders(Config config, File storeDirectory, FileSystemAbstraction fs) {
        for (DiagnosticsOfflineReportProvider provider : Service.load(DiagnosticsOfflineReportProvider.class)) {
            provider.init(fs, config, storeDirectory);
            this.registerOfflineProvider(provider);
        }
    }
}

