/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;
import org.neo4j.time.SystemNanoClock;

class TimeCheckPointThreshold
extends AbstractCheckPointThreshold {
    private volatile long lastCheckPointedTransactionId;
    private volatile long lastCheckPointTimeNanos;
    private final long timeMillisThreshold;
    private final SystemNanoClock clock;

    TimeCheckPointThreshold(long thresholdMillis, SystemNanoClock clock) {
        super("time threshold");
        this.timeMillisThreshold = thresholdMillis;
        this.clock = clock;
        long randomStartOffset = thresholdMillis > 0L ? ThreadLocalRandom.current().nextLong(thresholdMillis) : 0L;
        this.lastCheckPointTimeNanos = clock.nanos() + TimeUnit.MILLISECONDS.toNanos(randomStartOffset);
    }

    @Override
    public void initialize(long transactionId) {
        this.lastCheckPointedTransactionId = transactionId;
    }

    @Override
    protected boolean thresholdReached(long lastCommittedTransactionId) {
        return lastCommittedTransactionId > this.lastCheckPointedTransactionId && this.clock.nanos() - this.lastCheckPointTimeNanos >= TimeUnit.MILLISECONDS.toNanos(this.timeMillisThreshold);
    }

    @Override
    public void checkPointHappened(long transactionId) {
        this.lastCheckPointTimeNanos = this.clock.nanos();
        this.lastCheckPointedTransactionId = transactionId;
    }

    @Override
    public long checkFrequencyMillis() {
        return this.timeMillisThreshold;
    }
}

