/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class Loaders {
    private final RecordAccess.Loader<NodeRecord, Void> nodeLoader;
    private final RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader;
    private final RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader;
    private final RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader;
    private final RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader;
    private final RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader;
    private final RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader;
    private final RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader;

    public Loaders(NeoStores neoStores) {
        this(neoStores.getNodeStore(), neoStores.getPropertyStore(), neoStores.getRelationshipStore(), neoStores.getRelationshipGroupStore(), neoStores.getPropertyKeyTokenStore(), neoStores.getRelationshipTypeTokenStore(), neoStores.getLabelTokenStore(), neoStores.getSchemaStore());
    }

    public Loaders(RecordStore<NodeRecord> nodeStore, PropertyStore propertyStore, RecordStore<RelationshipRecord> relationshipStore, RecordStore<RelationshipGroupRecord> relationshipGroupStore, RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore, RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore, RecordStore<LabelTokenRecord> labelTokenStore, SchemaStore schemaStore) {
        this.nodeLoader = Loaders.nodeLoader(nodeStore);
        this.propertyLoader = Loaders.propertyLoader(propertyStore);
        this.relationshipLoader = Loaders.relationshipLoader(relationshipStore);
        this.relationshipGroupLoader = Loaders.relationshipGroupLoader(relationshipGroupStore);
        this.schemaRuleLoader = Loaders.schemaRuleLoader(schemaStore);
        this.propertyKeyTokenLoader = Loaders.propertyKeyTokenLoader(propertyKeyTokenStore);
        this.labelTokenLoader = Loaders.labelTokenLoader(labelTokenStore);
        this.relationshipTypeTokenLoader = Loaders.relationshipTypeTokenLoader(relationshipTypeTokenStore);
    }

    public RecordAccess.Loader<NodeRecord, Void> nodeLoader() {
        return this.nodeLoader;
    }

    public RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader() {
        return this.propertyLoader;
    }

    public RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader() {
        return this.relationshipLoader;
    }

    public RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader() {
        return this.relationshipGroupLoader;
    }

    public RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader() {
        return this.schemaRuleLoader;
    }

    public RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader() {
        return this.propertyKeyTokenLoader;
    }

    public RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader() {
        return this.labelTokenLoader;
    }

    public RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader() {
        return this.relationshipTypeTokenLoader;
    }

    public static RecordAccess.Loader<NodeRecord, Void> nodeLoader(final RecordStore<NodeRecord> store) {
        return new RecordAccess.Loader<NodeRecord, Void>(){

            @Override
            public NodeRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new NodeRecord(key));
            }

            @Override
            public NodeRecord load(long key, Void additionalData) {
                return (NodeRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(NodeRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public NodeRecord clone(NodeRecord nodeRecord) {
                return nodeRecord.clone();
            }
        };
    }

    public static RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader(final PropertyStore store) {
        return new RecordAccess.Loader<PropertyRecord, PrimitiveRecord>(){

            @Override
            public PropertyRecord newUnused(long key, PrimitiveRecord additionalData) {
                PropertyRecord record = new PropertyRecord(key);
                this.setOwner(record, additionalData);
                return Loaders.andMarkAsCreated(record);
            }

            private void setOwner(PropertyRecord record, PrimitiveRecord owner) {
                if (owner != null) {
                    owner.setIdTo(record);
                }
            }

            @Override
            public PropertyRecord load(long key, PrimitiveRecord additionalData) {
                PropertyRecord record = store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
                this.setOwner(record, additionalData);
                return record;
            }

            @Override
            public void ensureHeavy(PropertyRecord record) {
                for (PropertyBlock block : record) {
                    store.ensureHeavy(block);
                }
            }

            @Override
            public PropertyRecord clone(PropertyRecord propertyRecord) {
                return propertyRecord.clone();
            }
        };
    }

    public static RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader(final RecordStore<RelationshipRecord> store) {
        return new RecordAccess.Loader<RelationshipRecord, Void>(){

            @Override
            public RelationshipRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new RelationshipRecord(key));
            }

            @Override
            public RelationshipRecord load(long key, Void additionalData) {
                return (RelationshipRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(RelationshipRecord record) {
            }

            @Override
            public RelationshipRecord clone(RelationshipRecord relationshipRecord) {
                return relationshipRecord.clone();
            }
        };
    }

    public static RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader(final RecordStore<RelationshipGroupRecord> store) {
        return new RecordAccess.Loader<RelationshipGroupRecord, Integer>(){

            @Override
            public RelationshipGroupRecord newUnused(long key, Integer type) {
                RelationshipGroupRecord record = new RelationshipGroupRecord(key);
                record.setType(type);
                return Loaders.andMarkAsCreated(record);
            }

            @Override
            public RelationshipGroupRecord load(long key, Integer type) {
                return (RelationshipGroupRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(RelationshipGroupRecord record) {
            }

            @Override
            public RelationshipGroupRecord clone(RelationshipGroupRecord record) {
                return record.clone();
            }
        };
    }

    public static RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader(final SchemaStore store) {
        return new RecordAccess.Loader<SchemaRecord, SchemaRule>(){

            @Override
            public SchemaRecord newUnused(long key, SchemaRule additionalData) {
                return new SchemaRecord(store.allocateFrom(additionalData));
            }

            @Override
            public SchemaRecord load(long key, SchemaRule additionalData) {
                return new SchemaRecord(store.getRecords(key, RecordLoad.NORMAL));
            }

            @Override
            public void ensureHeavy(SchemaRecord records) {
                for (DynamicRecord record : records) {
                    store.ensureHeavy(record);
                }
            }

            @Override
            public SchemaRecord clone(SchemaRecord records) {
                return records.clone();
            }
        };
    }

    public static RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader(final RecordStore<PropertyKeyTokenRecord> store) {
        return new RecordAccess.Loader<PropertyKeyTokenRecord, Void>(){

            @Override
            public PropertyKeyTokenRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new PropertyKeyTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public PropertyKeyTokenRecord load(long key, Void additionalData) {
                return (PropertyKeyTokenRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(PropertyKeyTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public PropertyKeyTokenRecord clone(PropertyKeyTokenRecord record) {
                return record.clone();
            }
        };
    }

    public static RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader(final RecordStore<LabelTokenRecord> store) {
        return new RecordAccess.Loader<LabelTokenRecord, Void>(){

            @Override
            public LabelTokenRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new LabelTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public LabelTokenRecord load(long key, Void additionalData) {
                return (LabelTokenRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(LabelTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public LabelTokenRecord clone(LabelTokenRecord record) {
                return record.clone();
            }
        };
    }

    public static RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader(final RecordStore<RelationshipTypeTokenRecord> store) {
        return new RecordAccess.Loader<RelationshipTypeTokenRecord, Void>(){

            @Override
            public RelationshipTypeTokenRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new RelationshipTypeTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public RelationshipTypeTokenRecord load(long key, Void additionalData) {
                return (RelationshipTypeTokenRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(RelationshipTypeTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public RelationshipTypeTokenRecord clone(RelationshipTypeTokenRecord record) {
                return record.clone();
            }
        };
    }

    protected static <RECORD extends AbstractBaseRecord> RECORD andMarkAsCreated(RECORD record) {
        record.setCreated();
        return record;
    }
}

