/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.kernel.impl.proc.ParseUtil;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.Values;

public class ByteArrayConverter
implements Function<String, DefaultParameterValue>,
FieldSignature.InputMapper {
    @Override
    public DefaultParameterValue apply(String s) {
        String value = s.trim();
        if (value.equalsIgnoreCase("null")) {
            return DefaultParameterValue.ntByteArray(null);
        }
        List values = ParseUtil.parseList(value, Long.class);
        byte[] bytes = new byte[values.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = ((Long)values.get(i)).byteValue();
        }
        return DefaultParameterValue.ntByteArray((byte[])bytes);
    }

    public Object map(Object input) {
        if (input instanceof byte[]) {
            return input;
        }
        if (input instanceof List) {
            List list = (List)input;
            byte[] bytes = new byte[list.size()];
            for (int a = 0; a < bytes.length; ++a) {
                Object value = list.get(a);
                if (!(value instanceof Byte)) {
                    throw new IllegalArgumentException("Cannot convert " + value + " to byte for input to procedure");
                }
                bytes[a] = (Byte)value;
            }
            return bytes;
        }
        throw new IllegalArgumentException("Cannot convert " + input.getClass().getSimpleName() + " to byte[] for input to procedure");
    }

    public AnyValue map(AnyValue input) {
        if (input instanceof ByteArray) {
            return input;
        }
        if (input instanceof SequenceValue) {
            SequenceValue list = (SequenceValue)input;
            if (list.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                byte[] bytes = new byte[list.length()];
                for (int a = 0; a < bytes.length; ++a) {
                    bytes[a] = this.asByte(list.value(a));
                }
                return Values.byteArray((byte[])bytes);
            }
            byte[] bytes = new byte[list.length()];
            int i = 0;
            for (AnyValue anyValue : list) {
                bytes[i++] = this.asByte(anyValue);
            }
            return Values.byteArray((byte[])bytes);
        }
        throw new IllegalArgumentException("Cannot convert " + input.getClass().getSimpleName() + " to byte[] for input to procedure");
    }

    private byte asByte(AnyValue value) {
        if (value instanceof ByteValue) {
            return ((ByteValue)value).value();
        }
        throw new IllegalArgumentException("Cannot convert " + value.map((ValueMapper)new DefaultValueMapper(null)) + " to byte for input to procedure");
    }
}

