/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.impl.index.schema.CollectingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.CombinedPartSeeker;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckableIndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorPartSupplier;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.util.VisibleForTesting;

class ParallelNativeIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements IndexPopulator,
ConsistencyCheckableIndexPopulator {
    private final IndexLayout<KEY, VALUE> layout;
    private final ThreadLocal<ThreadLocalPopulator> threadLocalPopulators;
    private final List<ThreadLocalPopulator> partPopulators = new CopyOnWriteArrayList<ThreadLocalPopulator>();
    private final AtomicInteger nextPartId = new AtomicInteger();
    private NativeIndexPopulator<KEY, VALUE> completePopulator;
    private String failure;
    private boolean merged;
    private boolean closed;

    ParallelNativeIndexPopulator(File baseIndexFile, IndexLayout<KEY, VALUE> layout, NativeIndexPopulatorPartSupplier<KEY, VALUE> partSupplier) {
        this.layout = layout;
        this.threadLocalPopulators = ThreadLocal.withInitial(() -> this.newPartPopulator(baseIndexFile, partSupplier));
        this.completePopulator = partSupplier.part(baseIndexFile);
    }

    private synchronized ThreadLocalPopulator newPartPopulator(File baseIndexFile, NativeIndexPopulatorPartSupplier<KEY, VALUE> partSupplier) {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        if (this.merged) {
            throw new IllegalStateException("Already merged");
        }
        File file = new File(baseIndexFile + "-part-" + this.nextPartId.getAndIncrement());
        NativeIndexPopulator<KEY, VALUE> populator = partSupplier.part(file);
        ThreadLocalPopulator tlPopulator = new ThreadLocalPopulator(populator);
        this.partPopulators.add(tlPopulator);
        populator.create();
        return tlPopulator;
    }

    @Override
    public void create() {
        this.completePopulator.create();
    }

    @Override
    public synchronized void drop() {
        this.closed = true;
        try {
            this.closeAndDropAllParts();
        }
        finally {
            this.completePopulator.drop();
        }
    }

    private void closeAndDropAllParts() {
        Iterables.safeForAll(p -> ((ThreadLocalPopulator)p).populator.drop(), this.partPopulators);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> scanBatch) throws IndexEntryConflictException {
        ThreadLocalPopulator tlPopulator = this.threadLocalPopulators.get();
        tlPopulator.applyQueuedUpdates();
        tlPopulator.populator.add(scanBatch);
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        this.ensureMerged();
        this.completePopulator.verifyDeferredConstraints(nodePropertyAccessor);
    }

    @Override
    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return new CollectingIndexUpdater(updates -> {
            if (this.partPopulators.isEmpty()) {
                this.threadLocalPopulators.get();
            }
            this.partPopulators.forEach(p -> ((ThreadLocalPopulator)p).updates.add(updates));
        });
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) {
        this.closed = true;
        try {
            if (populationCompletedSuccessfully) {
                this.ensureMerged();
                this.completePopulator.close(true);
            } else {
                if (this.failure != null) {
                    this.completePopulator.markAsFailed(this.failure);
                }
                this.completePopulator.close(false);
            }
        }
        finally {
            this.closeAndDropAllParts();
        }
    }

    @Override
    public void markAsFailed(String failure) {
        this.failure = failure;
        this.completePopulator.markAsFailed(failure);
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        this.completePopulator.includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        this.ensureMerged();
        return this.completePopulator.sampleResult();
    }

    @Override
    public void consistencyCheck() {
        this.ensureMerged();
        this.completePopulator.consistencyCheck();
    }

    private synchronized void ensureMerged() {
        if (!this.merged) {
            this.merged = true;
            try {
                this.applyAllPendingUpdates();
                this.mergeParts();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (IndexEntryConflictException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void mergeParts() throws IOException {
        NativeIndexKey from = (NativeIndexKey)((Object)this.layout.newKey());
        NativeIndexKey to = (NativeIndexKey)((Object)this.layout.newKey());
        this.initKeysAsLowestAndHighest(from, to);
        try (Writer writer = this.completePopulator.tree.writer();
             CombinedPartSeeker<KEY, VALUE> combinedPartSeeker = new CombinedPartSeeker<KEY, VALUE>(this.layout, this.partSeekers(from, to));){
            while (combinedPartSeeker.next()) {
                writer.put(combinedPartSeeker.key(), combinedPartSeeker.value());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RawCursor<Hit<KEY, VALUE>, IOException>> partSeekers(KEY from, KEY to) throws IOException {
        ArrayList<RawCursor> seekers = new ArrayList<RawCursor>();
        boolean success = false;
        try {
            for (ThreadLocalPopulator partPopulator : this.partPopulators) {
                seekers.add(((ThreadLocalPopulator)partPopulator).populator.tree.seek(from, to));
            }
            success = true;
            ArrayList<RawCursor> arrayList = seekers;
            return arrayList;
        }
        finally {
            if (!success) {
                IOUtils.closeAll(seekers);
            }
        }
    }

    private void initKeysAsLowestAndHighest(KEY low, KEY high) {
        ((NativeIndexKey)((Object)low)).initialize(Long.MIN_VALUE);
        ((NativeIndexKey)((Object)low)).initValuesAsLowest();
        ((NativeIndexKey)((Object)high)).initialize(Long.MAX_VALUE);
        ((NativeIndexKey)((Object)high)).initValuesAsHighest();
    }

    private void applyAllPendingUpdates() throws IndexEntryConflictException {
        for (ThreadLocalPopulator part : this.partPopulators) {
            part.applyQueuedUpdates();
        }
    }

    @VisibleForTesting
    NativeIndexReader<KEY, VALUE> newReader() {
        return this.completePopulator.newReader();
    }

    private class ThreadLocalPopulator {
        private final NativeIndexPopulator<KEY, VALUE> populator;
        private final Queue<Collection<IndexEntryUpdate<?>>> updates = new ConcurrentLinkedQueue();

        ThreadLocalPopulator(NativeIndexPopulator<KEY, VALUE> populator) {
            this.populator = populator;
        }

        void applyQueuedUpdates() throws IndexEntryConflictException {
            if (!this.updates.isEmpty()) {
                try (IndexUpdater updater = this.populator.newPopulatingUpdater();){
                    Collection<IndexEntryUpdate<?>> batch;
                    while ((batch = this.updates.poll()) != null) {
                        for (IndexEntryUpdate<?> update : batch) {
                            updater.process(update);
                        }
                    }
                }
            }
        }
    }
}

