/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.helpers.Numbers;
import org.neo4j.unsafe.impl.batchimport.cache.BaseNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;

abstract class HeapNumberArray<N extends NumberArray<N>>
extends BaseNumberArray<N> {
    protected HeapNumberArray(int itemSize, long base) {
        super(itemSize, base);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.heapUsage(this.length() * (long)this.itemSize);
    }

    @Override
    public void close() {
    }

    protected int index(long index) {
        return Numbers.safeCastLongToInt((long)this.rebase(index));
    }
}

