/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaciton.monitor;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public class KernelTransactionMonitor
implements Runnable {
    private final KernelTransactions kernelTransactions;
    private final SystemNanoClock clock;
    private final Log log;

    public KernelTransactionMonitor(KernelTransactions kernelTransactions, SystemNanoClock clock, LogService logService) {
        this.kernelTransactions = kernelTransactions;
        this.clock = clock;
        this.log = logService.getInternalLog(KernelTransactionMonitor.class);
    }

    @Override
    public synchronized void run() {
        long nowNanos = this.clock.nanos();
        Set<KernelTransactionHandle> activeTransactions = this.kernelTransactions.activeTransactions();
        this.checkExpiredTransactions(activeTransactions, nowNanos);
    }

    private void checkExpiredTransactions(Set<KernelTransactionHandle> activeTransactions, long nowNanos) {
        for (KernelTransactionHandle activeTransaction : activeTransactions) {
            long transactionTimeoutMillis = activeTransaction.timeoutMillis();
            if (transactionTimeoutMillis <= 0L || !KernelTransactionMonitor.isTransactionExpired(activeTransaction, nowNanos, transactionTimeoutMillis) || activeTransaction.isSchemaTransaction() || !activeTransaction.markForTermination((Status)Status.Transaction.TransactionTimedOut)) continue;
            this.log.warn("Transaction %s timeout.", new Object[]{activeTransaction});
        }
    }

    private static boolean isTransactionExpired(KernelTransactionHandle activeTransaction, long nowNanos, long transactionTimeoutMillis) {
        return nowNanos - activeTransaction.startTimeNanos() > TimeUnit.MILLISECONDS.toNanos(transactionTimeoutMillis);
    }
}

