/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public class NativeIndexFileFilter
implements FileFilter {
    private final Path indexRoot;

    public NativeIndexFileFilter(File storeDir) {
        this.indexRoot = IndexDirectoryStructure.baseSchemaIndexFolder(storeDir).toPath().toAbsolutePath();
    }

    @Override
    public boolean accept(File file) {
        Path path = file.toPath();
        if (!path.toAbsolutePath().startsWith(this.indexRoot)) {
            return false;
        }
        Path schemaPath = this.indexRoot.relativize(path);
        int nameCount = schemaPath.getNameCount();
        boolean isPureLuceneProviderFile = nameCount >= 1 && schemaPath.getName(0).toString().equals("lucene");
        boolean isFusionLuceneProviderFile = nameCount >= 3 && schemaPath.getName(2).toString().startsWith("lucene-");
        return !isPureLuceneProviderFile && !isFusionLuceneProviderFile;
    }
}

