/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexConfigProvider;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Value;

class FusionIndexPopulator
extends FusionIndexBase<IndexPopulator>
implements IndexPopulator {
    private final long indexId;
    private final IndexDropAction dropAction;
    private final boolean archiveFailedIndex;

    FusionIndexPopulator(SlotSelector slotSelector, InstanceSelector<IndexPopulator> instanceSelector, long indexId, IndexDropAction dropAction, boolean archiveFailedIndex) {
        super(slotSelector, instanceSelector);
        this.indexId = indexId;
        this.dropAction = dropAction;
        this.archiveFailedIndex = archiveFailedIndex;
    }

    @Override
    public void create() {
        this.dropAction.drop(this.indexId, this.archiveFailedIndex);
        this.instanceSelector.forAll(IndexPopulator::create);
    }

    @Override
    public void drop() {
        this.instanceSelector.forAll(IndexPopulator::drop);
        this.dropAction.drop(this.indexId);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        LazyInstanceSelector<Collection> batchSelector = new LazyInstanceSelector<Collection>(slot -> new ArrayList());
        for (IndexEntryUpdate<?> update : updates) {
            batchSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF)).add(update);
        }
        for (IndexSlot slot2 : IndexSlot.values()) {
            Collection batch = batchSelector.getIfInstantiated(slot2);
            if (batch == null) continue;
            ((IndexPopulator)this.instanceSelector.select(slot2)).add(batch);
        }
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        for (IndexSlot slot : IndexSlot.values()) {
            ((IndexPopulator)this.instanceSelector.select(slot)).verifyDeferredConstraints(nodePropertyAccessor);
        }
    }

    @Override
    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        LazyInstanceSelector<IndexUpdater> updaterSelector = new LazyInstanceSelector<IndexUpdater>(slot -> ((IndexPopulator)this.instanceSelector.select((IndexSlot)((Object)slot))).newPopulatingUpdater(accessor));
        return new FusionIndexUpdater(this.slotSelector, updaterSelector);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) {
        this.instanceSelector.close(populator -> populator.close(populationCompletedSuccessfully));
    }

    @Override
    public void markAsFailed(String failure) {
        this.instanceSelector.forAll(populator -> populator.markAsFailed(failure));
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        ((IndexPopulator)this.instanceSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF))).includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        return FusionIndexSampler.combineSamples(this.instanceSelector.transform(IndexPopulator::sampleResult));
    }

    @Override
    public Map<String, Value> indexConfig() {
        HashMap<String, Value> indexConfig = new HashMap<String, Value>();
        this.instanceSelector.transform(IndexConfigProvider::indexConfig).forEach(source -> IndexConfigProvider.putAllNoOverwrite(indexConfig, source));
        return indexConfig;
    }
}

