/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.time.ZoneId;
import java.util.Objects;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public final class ClockContext {
    private final SystemNanoClock system;
    private Clock statement;
    private Clock transaction;

    public ClockContext() {
        this(Clocks.nanoClock());
    }

    public ClockContext(SystemNanoClock clock) {
        this.system = Objects.requireNonNull(clock, "system clock");
    }

    void initializeTransaction() {
        this.transaction = Clock.fixed(this.system.instant(), this.timezone());
        this.statement = null;
    }

    void initializeStatement() {
        this.statement = this.statement == null ? this.transaction : Clock.fixed(this.system.instant(), this.timezone());
    }

    public ZoneId timezone() {
        return this.system.getZone();
    }

    public SystemNanoClock systemClock() {
        return this.system;
    }

    public Clock statementClock() {
        assert (this.statement != null) : "statement clock not initialized";
        return this.statement;
    }

    public Clock transactionClock() {
        assert (this.transaction != null) : "transaction clock not initialized";
        return this.transaction;
    }
}

