/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.kernel.impl.index.schema.TemporalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.ValueCategory;

public class TemporalIndexProvider
extends IndexProvider {
    public static final String KEY = "temporal";
    static final IndexCapability CAPABILITY = new TemporalIndexCapability();
    private static final IndexProviderDescriptor TEMPORAL_PROVIDER_DESCRIPTOR = new IndexProviderDescriptor("temporal", "1.0");
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final IndexProvider.Monitor monitor;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final boolean readOnly;

    public TemporalIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(TEMPORAL_PROVIDER_DESCRIPTOR, directoryStructure);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    @Override
    public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        TemporalIndexFiles files = new TemporalIndexFiles(this.directoryStructure(), descriptor, this.fs);
        return new TemporalIndexPopulator(descriptor, samplingConfig, files, this.pageCache, this.fs, this.monitor);
    }

    @Override
    public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        TemporalIndexFiles files = new TemporalIndexFiles(this.directoryStructure(), descriptor, this.fs);
        return new TemporalIndexAccessor(descriptor, samplingConfig, this.pageCache, this.fs, this.recoveryCleanupWorkCollector, this.monitor, files, this.readOnly);
    }

    @Override
    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        TemporalIndexFiles temporalIndexFiles = new TemporalIndexFiles(this.directoryStructure(), descriptor, this.fs);
        try {
            for (TemporalIndexFiles.FileLayout subIndex : temporalIndexFiles.existing()) {
                String indexFailure = NativeIndexes.readFailureMessage(this.pageCache, subIndex.indexFile);
                if (indexFailure == null) continue;
                return indexFailure;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Index " + descriptor.getId() + " isn't failed");
    }

    @Override
    public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
        TemporalIndexFiles temporalIndexFiles = new TemporalIndexFiles(this.directoryStructure(), descriptor, this.fs);
        Iterable<TemporalIndexFiles.FileLayout> existing = temporalIndexFiles.existing();
        InternalIndexState state = InternalIndexState.ONLINE;
        for (TemporalIndexFiles.FileLayout subIndex : existing) {
            try {
                switch (NativeIndexes.readState(this.pageCache, subIndex.indexFile)) {
                    case FAILED: {
                        return InternalIndexState.FAILED;
                    }
                    case POPULATING: {
                        state = InternalIndexState.POPULATING;
                    }
                }
            }
            catch (IOException | MetadataMismatchException e) {
                this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
                return InternalIndexState.POPULATING;
            }
        }
        return state;
    }

    @Override
    public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
        return CAPABILITY;
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private static class TemporalIndexCapability
    implements IndexCapability {
        private TemporalIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return ORDER_BOTH;
            }
            return ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return IndexValueCapability.YES;
            }
            if (this.singleWildcard(valueCategories)) {
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.NO;
        }

        public boolean isFulltextIndex() {
            return false;
        }

        public boolean isEventuallyConsistent() {
            return false;
        }

        private boolean support(ValueCategory[] valueCategories) {
            return valueCategories.length == 1 && valueCategories[0] == ValueCategory.TEMPORAL;
        }
    }
}

