/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.register.Register;

public interface CountsAccessor
extends CountsVisitor.Visitable {
    public Register.DoubleLongRegister nodeCount(int var1, Register.DoubleLongRegister var2);

    public Register.DoubleLongRegister relationshipCount(int var1, int var2, int var3, Register.DoubleLongRegister var4);

    public Register.DoubleLongRegister indexUpdatesAndSize(long var1, Register.DoubleLongRegister var3);

    public Register.DoubleLongRegister indexSample(long var1, Register.DoubleLongRegister var3);

    public static final class Initializer
    implements CountsVisitor {
        private final Updater updater;
        private final IndexStatsUpdater stats;

        public Initializer(Updater updater, IndexStatsUpdater stats) {
            this.updater = updater;
            this.stats = stats;
        }

        @Override
        public void visitNodeCount(int labelId, long count) {
            this.updater.incrementNodeCount(labelId, count);
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            this.updater.incrementRelationshipCount(startLabelId, typeId, endLabelId, count);
        }

        @Override
        public void visitIndexStatistics(long indexId, long updates, long size) {
            this.stats.replaceIndexUpdateAndSize(indexId, updates, size);
        }

        @Override
        public void visitIndexSample(long indexId, long unique, long size) {
            this.stats.replaceIndexSample(indexId, unique, size);
        }
    }

    public static interface IndexStatsUpdater
    extends AutoCloseable {
        public void replaceIndexUpdateAndSize(long var1, long var3, long var5);

        public void replaceIndexSample(long var1, long var3, long var5);

        public void incrementIndexUpdates(long var1, long var3);

        @Override
        public void close();
    }

    public static interface Updater
    extends AutoCloseable {
        public void incrementNodeCount(long var1, long var3);

        public void incrementRelationshipCount(long var1, int var3, long var4, long var6);

        @Override
        public void close();
    }
}

