/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Exceptions;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;

public class UniquePropertyValueValidationException
extends ConstraintValidationException {
    private final Set<IndexEntryConflictException> conflicts;

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, IndexEntryConflictException conflict) {
        this(constraint, phase, Collections.singleton(conflict));
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Set<IndexEntryConflictException> conflicts) {
        super((ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", (Throwable)UniquePropertyValueValidationException.buildCauseChain(conflicts));
        this.conflicts = conflicts;
    }

    private static IndexEntryConflictException buildCauseChain(Set<IndexEntryConflictException> conflicts) {
        IndexEntryConflictException chainedConflicts = null;
        for (IndexEntryConflictException conflict : conflicts) {
            chainedConflicts = (IndexEntryConflictException)Exceptions.chain(chainedConflicts, (Throwable)conflict);
        }
        return chainedConflicts;
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Throwable cause) {
        super((ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", cause);
        this.conflicts = Collections.emptySet();
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        SchemaDescriptor schema = this.constraint.schema();
        StringBuilder message = new StringBuilder();
        Iterator<IndexEntryConflictException> iterator = this.conflicts.iterator();
        while (iterator.hasNext()) {
            IndexEntryConflictException conflict = iterator.next();
            message.append(conflict.evidenceMessage(tokenNameLookup, schema));
            if (!iterator.hasNext()) continue;
            message.append(System.lineSeparator());
        }
        return message.toString();
    }

    public Set<IndexEntryConflictException> conflicts() {
        return this.conflicts;
    }
}

