/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.TemporalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPartReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexReader
extends TemporalIndexCache<TemporalIndexPartReader<?>>
implements IndexReader {
    private final IndexDescriptor descriptor;

    TemporalIndexReader(IndexDescriptor descriptor, TemporalIndexAccessor accessor) {
        super(new PartFactory(accessor));
        this.descriptor = descriptor;
    }

    public void close() {
        FusionIndexBase.forAll(Resource::close, this);
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        NativeIndexReader partReader = (NativeIndexReader)this.uncheckedSelect(propertyValues[0].valueGroup());
        return partReader == null ? 0L : partReader.countIndexedNodes(nodeId, propertyKeyIds, propertyValues);
    }

    public IndexSampler createSampler() {
        ArrayList<IndexSampler> samplers = new ArrayList<IndexSampler>();
        for (TemporalIndexPartReader partReader : this) {
            samplers.add(partReader.createSampler());
        }
        return new FusionIndexSampler(samplers);
    }

    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
        NodeValueIterator nodeValueIterator = new NodeValueIterator();
        this.query(nodeValueIterator, IndexOrder.NONE, nodeValueIterator.needsValues(), predicates);
        return nodeValueIterator;
    }

    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, boolean needsValues, IndexQuery ... predicates) {
        if (predicates.length != 1) {
            throw new IllegalArgumentException("Only single property temporal indexes are supported.");
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExistsPredicate) {
            this.loadAll();
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, (IndexProgressor)multiProgressor, predicates, indexOrder, needsValues);
            for (NativeIndexReader reader : this) {
                reader.query(multiProgressor, indexOrder, needsValues, predicates);
            }
        } else if (this.validPredicate(predicate)) {
            NativeIndexReader part = (NativeIndexReader)this.uncheckedSelect(predicate.valueGroup());
            if (part != null) {
                part.query(cursor, indexOrder, needsValues, predicates);
            } else {
                cursor.initialize(this.descriptor, IndexProgressor.EMPTY, predicates, indexOrder, needsValues);
            }
        } else {
            cursor.initialize(this.descriptor, IndexProgressor.EMPTY, predicates, indexOrder, needsValues);
        }
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }

    private boolean validPredicate(IndexQuery predicate) {
        return predicate instanceof IndexQuery.ExactPredicate || predicate instanceof IndexQuery.RangePredicate;
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<TemporalIndexPartReader<?>> {
        private final TemporalIndexAccessor accessor;

        PartFactory(TemporalIndexAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public TemporalIndexPartReader<?> newDate() {
            return this.accessor.selectOrElse(ValueGroup.DATE, TemporalIndexAccessor.PartAccessor::newReader, null);
        }

        @Override
        public TemporalIndexPartReader<?> newLocalDateTime() {
            return this.accessor.selectOrElse(ValueGroup.LOCAL_DATE_TIME, TemporalIndexAccessor.PartAccessor::newReader, null);
        }

        @Override
        public TemporalIndexPartReader<?> newZonedDateTime() {
            return this.accessor.selectOrElse(ValueGroup.ZONED_DATE_TIME, TemporalIndexAccessor.PartAccessor::newReader, null);
        }

        @Override
        public TemporalIndexPartReader<?> newLocalTime() {
            return this.accessor.selectOrElse(ValueGroup.LOCAL_TIME, TemporalIndexAccessor.PartAccessor::newReader, null);
        }

        @Override
        public TemporalIndexPartReader<?> newZonedTime() {
            return this.accessor.selectOrElse(ValueGroup.ZONED_TIME, TemporalIndexAccessor.PartAccessor::newReader, null);
        }

        @Override
        public TemporalIndexPartReader<?> newDuration() {
            return this.accessor.selectOrElse(ValueGroup.DURATION, TemporalIndexAccessor.PartAccessor::newReader, null);
        }
    }
}

