/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsWriter;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;

class GenericNativeIndexAccessor
extends NativeIndexAccessor<GenericKey, NativeIndexValue> {
    private final IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings;
    private final IndexDirectoryStructure directoryStructure;
    private final SpaceFillingCurveConfiguration configuration;
    private Validator<Value[]> validator;

    GenericNativeIndexAccessor(PageCache pageCache, FileSystemAbstraction fs, File storeFile, IndexLayout<GenericKey, NativeIndexValue> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings, IndexDirectoryStructure directoryStructure, SpaceFillingCurveConfiguration configuration) {
        super(pageCache, fs, storeFile, layout, monitor, descriptor, new SpaceFillingCurveSettingsWriter(spaceFillingCurveSettings));
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.directoryStructure = directoryStructure;
        this.configuration = configuration;
        this.instantiateTree(recoveryCleanupWorkCollector, this.headerWriter);
    }

    @Override
    public void drop() {
        super.drop();
        try {
            NativeIndexes.deleteIndex(this.fileSystem, this.directoryStructure, this.descriptor.getId(), false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void afterTreeInstantiation(GBPTree<GenericKey, NativeIndexValue> tree) {
        this.validator = new GenericIndexKeyValidator(tree.keyValueSizeCap(), (Layout<GenericKey, NativeIndexValue>)this.layout, this.spaceFillingCurveSettings, this.pageCache.pageSize());
    }

    @Override
    public IndexReader newReader() {
        this.assertOpen();
        return new GenericNativeIndexReader((GBPTree<GenericKey, NativeIndexValue>)this.tree, this.layout, (IndexDescriptor)this.descriptor, this.spaceFillingCurveSettings, this.configuration);
    }

    @Override
    public void validateBeforeCommit(Value[] tuple) {
        this.validator.validate(tuple);
    }

    @Override
    public void force(IOLimiter ioLimiter) {
        this.tree.checkpoint(ioLimiter, (Consumer)this.headerWriter);
    }
}

