/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyRecordChange;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.values.storable.Value;

public class PropertyPhysicalToLogicalConverter {
    private final PropertyStore propertyStore;

    public PropertyPhysicalToLogicalConverter(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public void convertPropertyRecord(long entityId, Iterable<PropertyRecordChange> changes, EntityUpdates.Builder properties) {
        IntObjectHashMap beforeMap = new IntObjectHashMap();
        IntObjectHashMap afterMap = new IntObjectHashMap();
        this.mapBlocks(entityId, changes, (MutableIntObjectMap<PropertyBlock>)beforeMap, (MutableIntObjectMap<PropertyBlock>)afterMap);
        IntIterator uniqueIntIterator = this.uniqueIntIterator((IntObjectMap<PropertyBlock>)beforeMap, (IntObjectMap<PropertyBlock>)afterMap);
        while (uniqueIntIterator.hasNext()) {
            int key = uniqueIntIterator.next();
            PropertyBlock beforeBlock = (PropertyBlock)beforeMap.get(key);
            PropertyBlock afterBlock = (PropertyBlock)afterMap.get(key);
            if (beforeBlock != null && afterBlock != null) {
                if (beforeBlock.hasSameContentsAs(afterBlock)) continue;
                Value beforeVal = this.valueOf(beforeBlock);
                Value afterVal = this.valueOf(afterBlock);
                properties.changed(key, beforeVal, afterVal);
                continue;
            }
            if (afterBlock != null) {
                properties.added(key, this.valueOf(afterBlock));
                continue;
            }
            if (beforeBlock != null) {
                properties.removed(key, this.valueOf(beforeBlock));
                continue;
            }
            throw new IllegalStateException("Weird, an update with no property value for before or after");
        }
    }

    private IntIterator uniqueIntIterator(IntObjectMap<PropertyBlock> beforeMap, IntObjectMap<PropertyBlock> afterMap) {
        IntHashSet keys = new IntHashSet();
        keys.addAll((IntIterable)beforeMap.keySet());
        keys.addAll((IntIterable)afterMap.keySet());
        return keys.intIterator();
    }

    private void mapBlocks(long entityId, Iterable<PropertyRecordChange> changes, MutableIntObjectMap<PropertyBlock> beforeMap, MutableIntObjectMap<PropertyBlock> afterMap) {
        for (PropertyRecordChange change : changes) {
            this.equalCheck(change.getBefore().getEntityId(), entityId);
            this.equalCheck(change.getAfter().getEntityId(), entityId);
            this.mapBlocks(change.getBefore(), beforeMap);
            this.mapBlocks(change.getAfter(), afterMap);
        }
    }

    private void equalCheck(long entityId, long expectedEntityId) {
        assert (entityId == expectedEntityId) : "Entity id differs expected " + expectedEntityId + ", but was " + entityId;
    }

    private void mapBlocks(PropertyRecord record, MutableIntObjectMap<PropertyBlock> blocks) {
        for (PropertyBlock block : record) {
            blocks.put(block.getKeyIndexId(), (Object)block);
        }
    }

    private Value valueOf(PropertyBlock block) {
        if (block == null) {
            return null;
        }
        return block.getType().value(block, this.propertyStore);
    }
}

