/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.function.LongFunction;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.unsafe.impl.batchimport.store.PrepareIdSequence;

public class SecondaryUnitPrepareIdSequence
implements PrepareIdSequence {
    @Override
    public LongFunction<IdSequence> apply(IdSequence idSequence) {
        return new NeighbourIdSequence();
    }

    private static class NeighbourIdSequence
    implements LongFunction<IdSequence>,
    IdSequence {
        private long id;
        private boolean returned;

        private NeighbourIdSequence() {
        }

        @Override
        public IdSequence apply(long firstUnitId) {
            this.id = firstUnitId;
            this.returned = false;
            return this;
        }

        @Override
        public long nextId() {
            try {
                if (this.returned) {
                    throw new IllegalStateException("Already returned");
                }
                long l = this.id + 1L;
                return l;
            }
            finally {
                this.returned = true;
            }
        }

        @Override
        public IdRange nextIdBatch(int size) {
            throw new UnsupportedOperationException();
        }
    }
}

