/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.LockTracer;

public class LockingNodeUniqueIndexSeek {
    public static <CURSOR extends NodeValueIndexCursor> long apply(Locks.Client locks, LockTracer lockTracer, Supplier<CURSOR> cursors, UniqueNodeIndexSeeker<CURSOR> nodeIndexSeeker, IndexReference index, IndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException {
        int[] entityTokenIds = index.schema().getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IndexNotApplicableKernelException("Multi-token index " + index + " does not support uniqueness.");
        }
        long indexEntryId = ResourceTypes.indexEntryResourceId(entityTokenIds[0], predicates);
        locks.acquireShared(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
        try (NodeValueIndexCursor cursor = (NodeValueIndexCursor)cursors.get();){
            nodeIndexSeeker.nodeIndexSeekWithFreshIndexReader(index, cursor, predicates);
            if (!cursor.next()) {
                locks.releaseShared(ResourceTypes.INDEX_ENTRY, indexEntryId);
                locks.acquireExclusive(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
                nodeIndexSeeker.nodeIndexSeekWithFreshIndexReader(index, cursor, predicates);
                if (cursor.next()) {
                    locks.acquireShared(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
                    locks.releaseExclusive(ResourceTypes.INDEX_ENTRY, indexEntryId);
                }
            }
            long l = cursor.nodeReference();
            return l;
        }
    }

    static interface UniqueNodeIndexSeeker<CURSOR extends NodeValueIndexCursor> {
        public void nodeIndexSeekWithFreshIndexReader(IndexReference var1, CURSOR var2, IndexQuery.ExactPredicate ... var3) throws IndexNotFoundKernelException, IndexNotApplicableKernelException;
    }
}

