/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.time.Clock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.neo4j.helpers.MathUtil;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.LockType;
import org.neo4j.kernel.impl.locking.community.LockNotFoundException;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.logging.Logger;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.LockWaitEvent;

class RWLock {
    private final LockResource resource;
    private final LinkedList<LockRequest> waitingThreadList = new LinkedList();
    private final Map<Object, TxLockElement> txLockElementMap = new HashMap<Object, TxLockElement>();
    private final RagManager ragManager;
    private final Clock clock;
    private final long lockAcquisitionTimeoutMillis;
    private int totalReadCount;
    private int totalWriteCount;
    private int marked;

    RWLock(LockResource resource, RagManager ragManager, Clock clock, long lockAcquisitionTimeoutMillis) {
        this.resource = resource;
        this.ragManager = ragManager;
        this.clock = clock;
        this.lockAcquisitionTimeoutMillis = lockAcquisitionTimeoutMillis;
    }

    public Object resource() {
        return this.resource;
    }

    synchronized void mark() {
        this.marked = Math.incrementExact(this.marked);
    }

    private void unmark() {
        this.marked = MathUtil.decrementExactNotPastZero((int)this.marked);
    }

    synchronized boolean isMarked() {
        return this.marked > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean acquireReadLock(LockTracer tracer, Object tx) throws DeadlockDetectedException {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        LockRequest lockRequest = null;
        LockWaitEvent waitEvent = null;
        boolean addLockRequest = true;
        try {
            tle.incrementRequests();
            Thread currentThread = Thread.currentThread();
            long lockAcquisitionTimeBoundary = this.clock.millis() + this.lockAcquisitionTimeoutMillis;
            while (!tle.isTerminated() && this.totalWriteCount > tle.writeCount) {
                this.assertNotExpired(lockAcquisitionTimeBoundary);
                this.ragManager.checkWaitOn(this, tx);
                if (addLockRequest) {
                    lockRequest = new LockRequest(tle, LockType.READ, currentThread);
                    this.waitingThreadList.addFirst(lockRequest);
                }
                if (waitEvent == null) {
                    waitEvent = tracer.waitForLock(false, this.resource.type(), new long[]{this.resource.resourceId()});
                }
                addLockRequest = this.waitUninterruptedly(lockAcquisitionTimeBoundary);
                this.ragManager.stopWaitOn(this, tx);
            }
            if (!tle.isTerminated()) {
                this.registerReadLockAcquired(tx, tle);
                boolean bl = true;
                return bl;
            }
            if (tle.requests == 1 && tle.isFree()) {
                this.txLockElementMap.remove(tx);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
            }
            this.cleanupWaitingListRequests(lockRequest, tle, addLockRequest);
            Thread.interrupted();
            tle.decrementRequests();
            this.unmark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean tryAcquireReadLock(Object tx) {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            if (tle.isTerminated() || this.totalWriteCount > tle.writeCount) {
                boolean bl = false;
                return bl;
            }
            this.registerReadLockAcquired(tx, tle);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unmark();
        }
    }

    synchronized void releaseReadLock(Object tx) throws LockNotFoundException {
        TxLockElement tle = this.getLockElement(tx);
        if (tle.readCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have readLock");
        }
        this.totalReadCount = MathUtil.decrementExactNotPastZero((int)this.totalReadCount);
        tle.readCount = MathUtil.decrementExactNotPastZero((int)tle.readCount);
        if (tle.isFree()) {
            this.ragManager.lockReleased(this, tx);
            if (tle.hasNoRequests()) {
                this.txLockElementMap.remove(tx);
            }
        }
        if (!this.waitingThreadList.isEmpty()) {
            LockRequest lockRequest = this.waitingThreadList.getLast();
            if (lockRequest.lockType == LockType.WRITE) {
                if (this.totalReadCount == lockRequest.element.readCount) {
                    this.waitingThreadList.removeLast();
                    lockRequest.waitingThread.interrupt();
                } else {
                    ListIterator<LockRequest> listItr = this.waitingThreadList.listIterator(this.waitingThreadList.lastIndexOf(lockRequest));
                    while (listItr.hasPrevious()) {
                        lockRequest = listItr.previous();
                        if (lockRequest.lockType == LockType.WRITE && this.totalReadCount == lockRequest.element.readCount) {
                            listItr.remove();
                            lockRequest.waitingThread.interrupt();
                            break;
                        }
                        if (lockRequest.lockType != LockType.READ) continue;
                        listItr.remove();
                        lockRequest.waitingThread.interrupt();
                    }
                }
            } else if (this.totalWriteCount == 0) {
                this.waitingThreadList.removeLast();
                lockRequest.waitingThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean acquireWriteLock(LockTracer tracer, Object tx) throws DeadlockDetectedException {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        LockRequest lockRequest = null;
        LockWaitEvent waitEvent = null;
        boolean addLockRequest = true;
        try {
            tle.incrementRequests();
            Thread currentThread = Thread.currentThread();
            long lockAcquisitionTimeBoundary = this.clock.millis() + this.lockAcquisitionTimeoutMillis;
            while (!(tle.isTerminated() || this.totalWriteCount <= tle.writeCount && this.totalReadCount <= tle.readCount)) {
                this.assertNotExpired(lockAcquisitionTimeBoundary);
                this.ragManager.checkWaitOn(this, tx);
                if (addLockRequest) {
                    lockRequest = new LockRequest(tle, LockType.WRITE, currentThread);
                    this.waitingThreadList.addFirst(lockRequest);
                }
                if (waitEvent == null) {
                    waitEvent = tracer.waitForLock(true, this.resource.type(), new long[]{this.resource.resourceId()});
                }
                addLockRequest = this.waitUninterruptedly(lockAcquisitionTimeBoundary);
                this.ragManager.stopWaitOn(this, tx);
            }
            if (!tle.isTerminated()) {
                this.registerWriteLockAcquired(tx, tle);
                boolean bl = true;
                return bl;
            }
            if (tle.requests == 1 && tle.isFree()) {
                this.txLockElementMap.remove(tx);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
            }
            this.cleanupWaitingListRequests(lockRequest, tle, addLockRequest);
            Thread.interrupted();
            tle.decrementRequests();
            this.unmark();
        }
    }

    private boolean waitUninterruptedly(long lockAcquisitionTimeBoundary) {
        boolean addLockRequest;
        try {
            if (this.lockAcquisitionTimeoutMillis > 0L) {
                this.assertNotExpired(lockAcquisitionTimeBoundary);
                this.wait(Math.abs(lockAcquisitionTimeBoundary - this.clock.millis()));
            } else {
                this.wait();
            }
            addLockRequest = false;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            addLockRequest = true;
        }
        return addLockRequest;
    }

    private void cleanupWaitingListRequests(LockRequest lockRequest, TxLockElement lockElement, boolean addLockRequest) {
        if (lockRequest != null && (lockElement.isTerminated() || !addLockRequest)) {
            this.waitingThreadList.remove(lockRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean tryAcquireWriteLock(Object tx) {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            if (tle.isTerminated() || this.totalWriteCount > tle.writeCount || this.totalReadCount > tle.readCount) {
                boolean bl = false;
                return bl;
            }
            this.registerWriteLockAcquired(tx, tle);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unmark();
        }
    }

    synchronized void releaseWriteLock(Object tx) throws LockNotFoundException {
        TxLockElement tle = this.getLockElement(tx);
        if (tle.writeCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have writeLock");
        }
        this.totalWriteCount = MathUtil.decrementExactNotPastZero((int)this.totalWriteCount);
        tle.writeCount = MathUtil.decrementExactNotPastZero((int)tle.writeCount);
        if (tle.isFree()) {
            this.ragManager.lockReleased(this, tx);
            if (tle.hasNoRequests()) {
                this.txLockElementMap.remove(tx);
            }
        }
        if (this.totalWriteCount == 0 && this.waitingThreadList.size() > 0) {
            LockRequest lockRequest;
            do {
                lockRequest = this.waitingThreadList.removeLast();
                lockRequest.waitingThread.interrupt();
            } while (lockRequest.lockType != LockType.WRITE && !this.waitingThreadList.isEmpty());
        }
    }

    synchronized int getWriteCount() {
        return this.totalWriteCount;
    }

    synchronized int getReadCount() {
        return this.totalReadCount;
    }

    synchronized int getWaitingThreadsCount() {
        return this.waitingThreadList.size();
    }

    public synchronized boolean logTo(Logger logger) {
        logger.log("Total lock count: readCount=" + this.totalReadCount + " writeCount=" + this.totalWriteCount + " for " + this.resource);
        logger.log("Waiting list:");
        Iterator wElements = this.waitingThreadList.iterator();
        while (wElements.hasNext()) {
            LockRequest lockRequest = (LockRequest)wElements.next();
            logger.log("[" + lockRequest.waitingThread + "(" + lockRequest.element.readCount + "r," + lockRequest.element.writeCount + "w)," + (Object)((Object)lockRequest.lockType) + "]");
            if (wElements.hasNext()) {
                logger.log(",");
                continue;
            }
            logger.log("");
        }
        logger.log("Locking transactions:");
        for (TxLockElement tle : this.txLockElementMap.values()) {
            logger.log("" + tle.tx + "(" + tle.readCount + "r," + tle.writeCount + "w)");
        }
        return true;
    }

    public synchronized String describe() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" Total lock count: readCount=").append(this.totalReadCount).append(" writeCount=").append(this.totalWriteCount).append(" for ").append(this.resource).append("\n").append("Waiting list:\n");
        Iterator wElements = this.waitingThreadList.iterator();
        while (wElements.hasNext()) {
            LockRequest lockRequest = (LockRequest)wElements.next();
            sb.append("[").append(lockRequest.waitingThread).append("(").append(lockRequest.element.readCount).append("r,").append(lockRequest.element.writeCount).append("w),").append((Object)lockRequest.lockType).append("]\n");
            if (!wElements.hasNext()) continue;
            sb.append(",");
        }
        sb.append("Locking transactions:\n");
        for (TxLockElement tle : this.txLockElementMap.values()) {
            sb.append(tle.tx).append("(").append(tle.readCount).append("r,").append(tle.writeCount).append("w)\n");
        }
        return sb.toString();
    }

    public synchronized long maxWaitTime() {
        long max = 0L;
        for (LockRequest thread : this.waitingThreadList) {
            if (thread.since >= max) continue;
            max = thread.since;
        }
        return System.currentTimeMillis() - max;
    }

    synchronized void terminateLockRequestsForLockTransaction(Object lockTransaction) {
        TxLockElement lockElement = this.txLockElementMap.get(lockTransaction);
        if (lockElement != null && !lockElement.isTerminated()) {
            lockElement.setTerminated(true);
            for (LockRequest lockRequest : this.waitingThreadList) {
                if (!lockRequest.element.tx.equals(lockTransaction)) continue;
                lockRequest.waitingThread.interrupt();
            }
        }
    }

    public String toString() {
        return "RWLock[" + this.resource + ", hash=" + this.hashCode() + "]";
    }

    private void registerReadLockAcquired(Object tx, TxLockElement tle) {
        this.registerLockAcquired(tx, tle);
        this.totalReadCount = Math.incrementExact(this.totalReadCount);
        tle.readCount = Math.incrementExact(tle.readCount);
    }

    private void registerWriteLockAcquired(Object tx, TxLockElement tle) {
        this.registerLockAcquired(tx, tle);
        this.totalWriteCount = Math.incrementExact(this.totalWriteCount);
        tle.writeCount = Math.incrementExact(tle.writeCount);
    }

    private void registerLockAcquired(Object tx, TxLockElement tle) {
        if (tle.isFree()) {
            this.ragManager.lockAcquired(this, tx);
        }
    }

    private TxLockElement getLockElement(Object tx) {
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            throw new LockNotFoundException("No transaction lock element found for " + tx);
        }
        return tle;
    }

    private void assertTransaction(Object tx) {
        if (tx == null) {
            throw new IllegalArgumentException();
        }
    }

    private TxLockElement getOrCreateLockElement(Object tx) {
        this.assertTransaction(tx);
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            tle = new TxLockElement(tx);
            this.txLockElementMap.put(tx, tle);
        }
        return tle;
    }

    private void assertNotExpired(long timeBoundary) {
        if (this.lockAcquisitionTimeoutMillis > 0L && timeBoundary < this.clock.millis()) {
            throw new LockAcquisitionTimeoutException(this.resource.type(), this.resource.resourceId(), this.lockAcquisitionTimeoutMillis);
        }
    }

    synchronized Object getTxLockElementCount() {
        return this.txLockElementMap.size();
    }

    private static class LockRequest {
        private final TxLockElement element;
        private final LockType lockType;
        private final Thread waitingThread;
        private final long since = System.currentTimeMillis();

        LockRequest(TxLockElement element, LockType lockType, Thread thread) {
            this.element = element;
            this.lockType = lockType;
            this.waitingThread = thread;
        }
    }

    private static class TxLockElement {
        private final Object tx;
        private int readCount;
        private int writeCount;
        private int requests;
        private boolean terminated;

        TxLockElement(Object tx) {
            this.tx = tx;
        }

        void incrementRequests() {
            this.requests = Math.incrementExact(this.requests);
        }

        void decrementRequests() {
            this.requests = MathUtil.decrementExactNotPastZero((int)this.requests);
        }

        boolean hasNoRequests() {
            return this.requests == 0;
        }

        boolean isFree() {
            return this.readCount == 0 && this.writeCount == 0;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public void setTerminated(boolean terminated) {
            this.terminated = terminated;
        }
    }
}

