/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Set;
import java.util.function.Function;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;

public class IndexMapReference
implements IndexMapSnapshotProvider {
    private volatile IndexMap indexMap = new IndexMap();

    @Override
    public IndexMap indexMapSnapshot() {
        return this.indexMap.clone();
    }

    public synchronized <E extends Exception> void modify(Function<IndexMap, IndexMap> modifier) throws E {
        IndexMap snapshot = this.indexMapSnapshot();
        this.indexMap = modifier.apply(snapshot);
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(indexId);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for index id " + indexId + " exists.");
        }
        return proxy;
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(descriptor);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for " + descriptor + " exists.");
        }
        return proxy;
    }

    public long getIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(descriptor);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for " + descriptor + " exists.");
        }
        return this.indexMap.getIndexId(descriptor);
    }

    public long getOnlineIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.getIndexProxy(descriptor);
        switch (proxy.getState()) {
            case ONLINE: {
                return this.indexMap.getIndexId(descriptor);
            }
        }
        throw new IndexNotFoundKernelException("Expected index on " + descriptor + " to be online.");
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexMap.getAllIndexProxies();
    }

    public Set<SchemaDescriptor> getRelatedIndexes(long[] changedEntityTokens, long[] unchangedEntityTokens, IntSet properties, EntityType entityType) {
        return this.indexMap.getRelatedIndexes(changedEntityTokens, unchangedEntityTokens, properties, entityType);
    }

    public IndexUpdaterMap createIndexUpdaterMap(IndexUpdateMode mode) {
        return new IndexUpdaterMap(this.indexMap, mode);
    }

    public void validateBeforeCommit(SchemaDescriptor index, Value[] tuple) {
        IndexProxy proxy = this.indexMap.getIndexProxy(index);
        if (proxy != null) {
            proxy.validateBeforeCommit(tuple);
        }
    }
}

