/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.PropertyLoader;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;

public class EntityUpdates
implements PropertyLoader.PropertyLoadSink {
    private final long entityId;
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private long[] entityTokensBefore;
    private long[] entityTokensAfter;
    private final MutableIntObjectMap<PropertyValue> knownProperties;
    private boolean hasLoadedAdditionalProperties;
    private static PropertyValue noValue = new PropertyValue(null, null, PropertyValueType.NoValue);

    private void put(int propertyKeyId, PropertyValue propertyValue) {
        this.knownProperties.put(propertyKeyId, (Object)propertyValue);
    }

    public static Builder forEntity(long entityId) {
        return new Builder(new EntityUpdates(entityId, EMPTY_LONG_ARRAY, EMPTY_LONG_ARRAY));
    }

    private EntityUpdates(long entityId, long[] entityTokensBefore, long[] entityTokensAfter) {
        this.entityId = entityId;
        this.entityTokensBefore = entityTokensBefore;
        this.entityTokensAfter = entityTokensAfter;
        this.knownProperties = new IntObjectHashMap();
    }

    public final long getEntityId() {
        return this.entityId;
    }

    long[] entityTokensChanged() {
        return PrimitiveArrays.symmetricDifference((long[])this.entityTokensBefore, (long[])this.entityTokensAfter);
    }

    long[] entityTokensUnchanged() {
        return PrimitiveArrays.intersect((long[])this.entityTokensBefore, (long[])this.entityTokensAfter);
    }

    IntSet propertiesChanged() {
        assert (!this.hasLoadedAdditionalProperties) : "Calling propertiesChanged() is not valid after non-changed properties have already been loaded.";
        return this.knownProperties.keySet().toImmutable();
    }

    @Override
    public void onProperty(int propertyId, Value value) {
        this.knownProperties.put(propertyId, (Object)EntityUpdates.unchanged(value));
    }

    public <INDEX_KEY extends SchemaDescriptorSupplier> Iterable<IndexEntryUpdate<INDEX_KEY>> forIndexKeys(Iterable<INDEX_KEY> indexKeys) {
        Iterable potentiallyRelevant = Iterables.filter(indexKey -> this.atLeastOneRelevantChange(indexKey.schema()), indexKeys);
        return this.gatherUpdatesForPotentials(potentiallyRelevant);
    }

    public <INDEX_KEY extends SchemaDescriptorSupplier> Iterable<IndexEntryUpdate<INDEX_KEY>> forIndexKeys(Iterable<INDEX_KEY> indexKeys, PropertyLoader propertyLoader, EntityType type) {
        ArrayList<SchemaDescriptorSupplier> potentiallyRelevant = new ArrayList<SchemaDescriptorSupplier>();
        IntHashSet additionalPropertiesToLoad = new IntHashSet();
        for (SchemaDescriptorSupplier indexKey : indexKeys) {
            if (!this.atLeastOneRelevantChange(indexKey.schema())) continue;
            potentiallyRelevant.add(indexKey);
            this.gatherPropsToLoad(indexKey.schema(), (MutableIntSet)additionalPropertiesToLoad);
        }
        if (!additionalPropertiesToLoad.isEmpty()) {
            this.loadProperties(propertyLoader, (MutableIntSet)additionalPropertiesToLoad, type);
        }
        return this.gatherUpdatesForPotentials(potentiallyRelevant);
    }

    private <INDEX_KEY extends SchemaDescriptorSupplier> Iterable<IndexEntryUpdate<INDEX_KEY>> gatherUpdatesForPotentials(Iterable<INDEX_KEY> potentiallyRelevant) {
        ArrayList<IndexEntryUpdate<INDEX_KEY>> indexUpdates = new ArrayList<IndexEntryUpdate<INDEX_KEY>>();
        for (SchemaDescriptorSupplier indexKey : potentiallyRelevant) {
            SchemaDescriptor schema = indexKey.schema();
            boolean relevantBefore = this.relevantBefore(schema);
            boolean relevantAfter = this.relevantAfter(schema);
            int[] propertyIds = schema.getPropertyIds();
            if (relevantBefore && !relevantAfter) {
                indexUpdates.add(IndexEntryUpdate.remove(this.entityId, indexKey, this.valuesBefore(propertyIds)));
                continue;
            }
            if (!relevantBefore && relevantAfter) {
                indexUpdates.add(IndexEntryUpdate.add(this.entityId, indexKey, this.valuesAfter(propertyIds)));
                continue;
            }
            if (!relevantBefore || !relevantAfter || !this.valuesChanged(propertyIds, schema.propertySchemaType())) continue;
            indexUpdates.add(IndexEntryUpdate.change(this.entityId, indexKey, this.valuesBefore(propertyIds), this.valuesAfter(propertyIds)));
        }
        return indexUpdates;
    }

    private boolean relevantBefore(SchemaDescriptor schema) {
        return schema.isAffected(this.entityTokensBefore) && this.hasPropsBefore(schema.getPropertyIds(), schema.propertySchemaType());
    }

    private boolean relevantAfter(SchemaDescriptor schema) {
        return schema.isAffected(this.entityTokensAfter) && this.hasPropsAfter(schema.getPropertyIds(), schema.propertySchemaType());
    }

    private void loadProperties(PropertyLoader propertyLoader, MutableIntSet additionalPropertiesToLoad, EntityType type) {
        this.hasLoadedAdditionalProperties = true;
        propertyLoader.loadProperties(this.entityId, type, additionalPropertiesToLoad, this);
        MutableIntIterator propertiesWithNoValue = additionalPropertiesToLoad.intIterator();
        while (propertiesWithNoValue.hasNext()) {
            this.knownProperties.put(propertiesWithNoValue.next(), (Object)noValue);
        }
    }

    private void gatherPropsToLoad(SchemaDescriptor schema, MutableIntSet target) {
        for (int propertyId : schema.getPropertyIds()) {
            if (this.knownProperties.get(propertyId) != null) continue;
            target.add(propertyId);
        }
    }

    private boolean atLeastOneRelevantChange(SchemaDescriptor schema) {
        boolean affectedBefore = schema.isAffected(this.entityTokensBefore);
        boolean affectedAfter = schema.isAffected(this.entityTokensAfter);
        if (affectedBefore && affectedAfter) {
            for (int propertyId : schema.getPropertyIds()) {
                if (!this.knownProperties.containsKey(propertyId)) continue;
                return true;
            }
            return false;
        }
        return affectedBefore || affectedAfter;
    }

    private boolean hasPropsBefore(int[] propertyIds, SchemaDescriptor.PropertySchemaType propertySchemaType) {
        boolean found = false;
        for (int propertyId : propertyIds) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.getIfAbsent(propertyId, (Function0 & Serializable)() -> noValue);
            if (!propertyValue.hasBefore()) {
                if (propertySchemaType != SchemaDescriptor.PropertySchemaType.COMPLETE_ALL_TOKENS) continue;
                return false;
            }
            found = true;
        }
        return found;
    }

    private boolean hasPropsAfter(int[] propertyIds, SchemaDescriptor.PropertySchemaType propertySchemaType) {
        boolean found = false;
        for (int propertyId : propertyIds) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.getIfAbsent(propertyId, (Function0 & Serializable)() -> noValue);
            if (!propertyValue.hasAfter()) {
                if (propertySchemaType != SchemaDescriptor.PropertySchemaType.COMPLETE_ALL_TOKENS) continue;
                return false;
            }
            found = true;
        }
        return found;
    }

    private Value[] valuesBefore(int[] propertyIds) {
        Value[] values = new Value[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            values[i] = ((PropertyValue)this.knownProperties.get(propertyIds[i])).before;
        }
        return values;
    }

    private Value[] valuesAfter(int[] propertyIds) {
        Value[] values = new Value[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.get(propertyIds[i]);
            values[i] = propertyValue == null ? null : propertyValue.after;
        }
        return values;
    }

    private boolean valuesChanged(int[] propertyIds, SchemaDescriptor.PropertySchemaType propertySchemaType) {
        if (propertySchemaType == SchemaDescriptor.PropertySchemaType.COMPLETE_ALL_TOKENS) {
            for (int propertyId : propertyIds) {
                if (((PropertyValue)this.knownProperties.get(propertyId)).type != PropertyValueType.Changed) continue;
                return true;
            }
            return false;
        }
        for (int propertyId : propertyIds) {
            PropertyValueType type = ((PropertyValue)this.knownProperties.get(propertyId)).type;
            if (type == PropertyValueType.UnChanged || type == PropertyValueType.NoValue) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("[").append(this.entityId);
        result.append(", entityTokensBefore:").append(Arrays.toString(this.entityTokensBefore));
        result.append(", entityTokensAfter:").append(Arrays.toString(this.entityTokensAfter));
        this.knownProperties.forEachKeyValue((IntObjectProcedure & Serializable)(key, propertyValue) -> {
            result.append(", ");
            result.append(key);
            result.append(" -> ");
            result.append(propertyValue);
        });
        return result.append(']').toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityUpdates that = (EntityUpdates)o;
        return this.entityId == that.entityId && Arrays.equals(this.entityTokensBefore, that.entityTokensBefore) && Arrays.equals(this.entityTokensAfter, that.entityTokensAfter);
    }

    public int hashCode() {
        int result = Objects.hash(this.entityId);
        result = 31 * result + Arrays.hashCode(this.entityTokensBefore);
        result = 31 * result + Arrays.hashCode(this.entityTokensAfter);
        return result;
    }

    private static PropertyValue before(Value value) {
        return new PropertyValue(value, null, PropertyValueType.Before);
    }

    private static PropertyValue after(Value value) {
        return new PropertyValue(null, value, PropertyValueType.After);
    }

    private static PropertyValue unchanged(Value value) {
        return new PropertyValue(value, value, PropertyValueType.UnChanged);
    }

    private static PropertyValue changed(Value before, Value after) {
        return new PropertyValue(before, after, PropertyValueType.Changed);
    }

    static /* synthetic */ long[] access$502(EntityUpdates x0, long[] x1) {
        x0.entityTokensBefore = x1;
        return x1;
    }

    static /* synthetic */ long[] access$602(EntityUpdates x0, long[] x1) {
        x0.entityTokensAfter = x1;
        return x1;
    }

    private static class PropertyValue {
        private final Value before;
        private final Value after;
        private final PropertyValueType type;

        private PropertyValue(Value before, Value after, PropertyValueType type) {
            this.before = before;
            this.after = after;
            this.type = type;
        }

        boolean hasBefore() {
            return this.before != null;
        }

        boolean hasAfter() {
            return this.after != null;
        }

        public String toString() {
            switch (this.type) {
                case NoValue: {
                    return "NoValue";
                }
                case Before: {
                    return String.format("Before(%s)", this.before);
                }
                case After: {
                    return String.format("After(%s)", this.after);
                }
                case UnChanged: {
                    return String.format("UnChanged(%s)", this.after);
                }
                case Changed: {
                    return String.format("Changed(from=%s, to=%s)", this.before, this.after);
                }
            }
            throw new IllegalStateException("This cannot happen!");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyValue that = (PropertyValue)o;
            if (this.type != that.type) {
                return false;
            }
            switch (this.type) {
                case NoValue: {
                    return true;
                }
                case Before: {
                    return this.before.equals(that.before);
                }
                case After: {
                    return this.after.equals(that.after);
                }
                case UnChanged: {
                    return this.after.equals(that.after);
                }
                case Changed: {
                    return this.before.equals(that.before) && this.after.equals(that.after);
                }
            }
            throw new IllegalStateException("This cannot happen!");
        }

        public int hashCode() {
            int result = this.before != null ? this.before.hashCode() : 0;
            result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    static enum PropertyValueType {
        NoValue,
        Before,
        After,
        UnChanged,
        Changed;

    }

    public static class Builder {
        private EntityUpdates updates;

        private Builder(EntityUpdates updates) {
            this.updates = updates;
        }

        public Builder added(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, EntityUpdates.after(value));
            return this;
        }

        public Builder removed(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, EntityUpdates.before(value));
            return this;
        }

        public Builder changed(int propertyKeyId, Value before, Value after) {
            this.updates.put(propertyKeyId, EntityUpdates.changed(before, after));
            return this;
        }

        public Builder existing(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, EntityUpdates.unchanged(value));
            return this;
        }

        public Builder withTokens(long ... entityTokens) {
            EntityUpdates.access$502(this.updates, entityTokens);
            EntityUpdates.access$602(this.updates, entityTokens);
            return this;
        }

        public Builder withTokensAfter(long ... entityTokensAfter) {
            EntityUpdates.access$602(this.updates, entityTokensAfter);
            return this;
        }

        public EntityUpdates build() {
            return this.updates;
        }
    }
}

