/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.impl.store.kvstore.ActiveState;
import org.neo4j.kernel.impl.store.kvstore.ConcurrentMapState;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;

@Inherited
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface State {
    public Strategy value();

    public static enum Strategy implements ActiveState.Factory
    {
        CONCURRENT_HASH_MAP{

            @Override
            public <Key> ActiveState<Key> open(ReadableState<Key> store, File file, VersionContextSupplier versionContextSupplier) {
                return new ConcurrentMapState<Key>(store, file, versionContextSupplier);
            }
        }
        ,
        READ_ONLY_CONCURRENT_HASH_MAP{

            @Override
            public <Key> ActiveState<Key> open(ReadableState<Key> store, File file, VersionContextSupplier versionContextSupplier) {
                return new ConcurrentMapState<Key>(store, file, EmptyVersionContextSupplier.EMPTY){

                    @Override
                    protected boolean hasChanges() {
                        return false;
                    }
                };
            }
        };

    }
}

