/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.index.internal.gbptree.Header;

class NativeIndexHeaderReader
implements Header.Reader {
    private final Header.Reader additionalReader;
    byte state;
    String failureMessage;

    NativeIndexHeaderReader(Header.Reader additionalReader) {
        this.additionalReader = additionalReader;
    }

    public void read(ByteBuffer headerData) {
        this.state = headerData.get();
        if (this.state == 0) {
            this.failureMessage = NativeIndexHeaderReader.readFailureMessage(headerData);
        } else {
            this.additionalReader.read(headerData);
        }
    }

    public static String readFailureMessage(ByteBuffer headerData) {
        short messageLength = headerData.getShort();
        byte[] failureMessageBytes = new byte[messageLength];
        headerData.get(failureMessageBytes);
        return new String(failureMessageBytes, StandardCharsets.UTF_8);
    }
}

