/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class GeometryType
extends Type {
    private static final int MASK_CODE = 262143;
    private static final int MASK_DIMENSIONS_READ = 0x1C0000;
    private static final int MASK_TABLE_READ = 0xC00000;
    private static final int SHIFT_DIMENSIONS = Integer.bitCount(262143);
    private static final int SHIFT_TABLE = SHIFT_DIMENSIONS + 1 + Integer.bitCount(0x1C0000);
    private static final int MASK_TABLE_PUT = 0xC00000 >>> SHIFT_TABLE;
    private static final int MASK_DIMENSIONS_PUT = 0x1C0000 >>> SHIFT_DIMENSIONS;

    GeometryType(byte typeId) {
        super(ValueGroup.GEOMETRY, typeId, (Value)PointValue.MIN_VALUE, (Value)PointValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey state) {
        int coordinatesSize = GeometryType.dimensions(state) * 8;
        return 11 + coordinatesSize;
    }

    static int dimensions(GenericKey state) {
        return Math.toIntExact(state.long3);
    }

    @Override
    void copyValue(GenericKey to, GenericKey from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
        to.long2 = from.long2;
        to.long3 = from.long3;
        int dimensions = GeometryType.dimensions(from);
        to.long1Array = GeometryType.ensureBigEnough(to.long1Array, dimensions);
        System.arraycopy(from.long1Array, 0, to.long1Array, 0, dimensions);
        to.spaceFillingCurve = from.spaceFillingCurve;
    }

    @Override
    Value asValue(GenericKey state) {
        GeometryType.assertHasCoordinates(state);
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)((int)state.long1), (int)((int)state.long2));
        return GeometryType.asValue(state, crs, 0);
    }

    static PointValue asValue(GenericKey state, CoordinateReferenceSystem crs, int offset) {
        double[] coordinates = new double[GeometryType.dimensions(state)];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = Double.longBitsToDouble(state.long1Array[offset + i]);
        }
        return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinates);
    }

    @Override
    int compareValue(GenericKey left, GenericKey right) {
        return GeometryType.compare(left.long0, left.long1, left.long2, right.long0, right.long1, right.long2);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        GeometryType.putCrs(cursor, state.long1, state.long2, state.long3);
        GeometryType.putPoint(cursor, state.long0, state.long3, state.long1Array, 0);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey into) {
        return GeometryType.readCrs(cursor, into) && GeometryType.readPoint(cursor, into);
    }

    @Override
    String toString(GenericKey state) {
        return String.format("Geometry[tableId:%d, code:%d, rawValue:%d]", state.long1, state.long2, state.long0);
    }

    @Override
    void minimalSplitter(GenericKey left, GenericKey right, GenericKey into) {
        super.minimalSplitter(left, right, into);
        into.long3 = 0L;
    }

    static int compare(long this_long0, long this_long1, long this_long2, long that_long0, long that_long1, long that_long2) {
        int tableIdComparison = Integer.compare((int)this_long1, (int)that_long1);
        if (tableIdComparison != 0) {
            return tableIdComparison;
        }
        int codeComparison = Integer.compare((int)this_long2, (int)that_long2);
        if (codeComparison != 0) {
            return codeComparison;
        }
        return Long.compare(this_long0, that_long0);
    }

    static void putCrs(PageCursor cursor, long long1, long long2, long long3) {
        GeometryType.assertValueWithin(long1, MASK_TABLE_PUT, "tableId");
        GeometryType.assertValueWithin(long2, 262143, "code");
        GeometryType.assertValueWithin(long3, MASK_DIMENSIONS_PUT, "dimensions");
        int header = (int)(long1 << SHIFT_TABLE | long3 << SHIFT_DIMENSIONS | long2);
        GeometryType.put3BInt(cursor, header);
    }

    private static void assertValueWithin(long value, int maskAllowed, String name) {
        if ((value & (long)(~maskAllowed)) != 0L) {
            throw new IllegalArgumentException("Expected 0 < " + name + " <= " + maskAllowed + ", but was " + value);
        }
    }

    static void putPoint(PageCursor cursor, long long0, long long3, long[] long1Array, int long1ArrayOffset) {
        cursor.putLong(long0);
        int i = 0;
        while ((long)i < long3) {
            cursor.putLong(long1Array[long1ArrayOffset + i]);
            ++i;
        }
    }

    static void assertHasCoordinates(GenericKey state) {
        if (state.long3 == 0L || state.long1Array == null) {
            throw new IllegalStateException("This geometry key doesn't have coordinates and can therefore neither be persisted nor generate point value.");
        }
    }

    private static void put3BInt(PageCursor cursor, int value) {
        cursor.putShort((short)value);
        cursor.putByte((byte)(value >>> 16));
    }

    static boolean readCrs(PageCursor cursor, GenericKey into) {
        int header = GeometryType.read3BInt(cursor);
        into.long1 = (header & 0xC00000) >>> SHIFT_TABLE;
        into.long2 = header & 0x3FFFF;
        into.long3 = (header & 0x1C0000) >>> SHIFT_DIMENSIONS;
        return true;
    }

    private static boolean readPoint(PageCursor cursor, GenericKey into) {
        into.long0 = cursor.getLong();
        int dimensions = GeometryType.dimensions(into);
        into.long1Array = GeometryType.ensureBigEnough(into.long1Array, dimensions);
        for (int i = 0; i < dimensions; ++i) {
            into.long1Array[i] = cursor.getLong();
        }
        return true;
    }

    private static int read3BInt(PageCursor cursor) {
        int low = cursor.getShort() & 0xFFFF;
        int high = cursor.getByte() & 0xFF;
        return high << 16 | low;
    }

    void write(GenericKey state, long derivedSpaceFillingCurveValue, double[] coordinate) {
        state.long0 = derivedSpaceFillingCurveValue;
        state.long1Array = GeometryType.ensureBigEnough(state.long1Array, coordinate.length);
        for (int i = 0; i < coordinate.length; ++i) {
            state.long1Array[i] = Double.doubleToLongBits(coordinate[i]);
        }
        state.long3 = coordinate.length;
    }
}

