/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsWriter;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

class GenericIndexKeyValidator
implements Validator<Value[]> {
    private final int maxLength;
    private final Layout<GenericKey, NativeIndexValue> layout;
    private final IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings;
    private final int maxNumberOfCRSs;

    GenericIndexKeyValidator(int maxLength, Layout<GenericKey, NativeIndexValue> layout, IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings, int pageSize) {
        this.maxLength = maxLength;
        this.layout = layout;
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        int actualMax = SpaceFillingCurveSettingsWriter.maxNumberOfSettings(pageSize);
        this.maxNumberOfCRSs = actualMax - actualMax / 10;
    }

    @Override
    public void validate(Value[] values) {
        int size;
        int worstCaseSize = GenericIndexKeyValidator.worstCaseLength(values);
        if (worstCaseSize > this.maxLength && (size = this.actualLength(values)) > this.maxLength) {
            throw new IllegalArgumentException(String.format("Property value size:%d of %s is too large to index into this particular index. Please see index documentation for limitations.", size, Arrays.toString(values)));
        }
        if (this.spaceFillingCurveSettings.additionalValuesCouldExceed(values, this.maxNumberOfCRSs)) {
            throw new UnsupportedOperationException(String.format("Adding %s would exceed number of crs settings limit %d for this index", Arrays.toString(values), this.maxNumberOfCRSs));
        }
    }

    private static int worstCaseLength(Value[] values) {
        int length = 8;
        for (Value value : values) {
            length += 8;
            length += GenericIndexKeyValidator.worstCaseLength((AnyValue)value);
        }
        return length;
    }

    private static int worstCaseLength(AnyValue value) {
        if (value.isSequenceValue()) {
            SequenceValue sequenceValue = (SequenceValue)value;
            if (sequenceValue instanceof TextArray) {
                TextArray textArray = (TextArray)sequenceValue;
                int length = 0;
                for (int i = 0; i < textArray.length(); ++i) {
                    length += GenericIndexKeyValidator.stringWorstCaseLength(textArray.stringValue(i).length());
                }
                return length;
            }
            return sequenceValue.length() * 32;
        }
        switch (((Value)value).valueGroup().category()) {
            case TEXT: {
                return GenericIndexKeyValidator.stringWorstCaseLength(((TextValue)value).length());
            }
        }
        return 32;
    }

    private static int stringWorstCaseLength(int stringLength) {
        return 2 + stringLength * 4;
    }

    private int actualLength(Value[] values) {
        GenericKey key = (GenericKey)((Object)this.layout.newKey());
        key.initialize(0L);
        for (int i = 0; i < values.length; ++i) {
            key.initFromValue(i, values[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
        return key.size();
    }
}

