/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Comparator;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

abstract class Type {
    private static final long MASK_BOOLEAN = 1L;
    static final Comparator<Type> COMPARATOR = Comparator.comparing(t -> t.valueGroup);
    final ValueGroup valueGroup;
    final byte typeId;
    private final Value minValue;
    private final Value maxValue;

    Type(ValueGroup valueGroup, byte typeId, Value minValue, Value maxValue) {
        this.valueGroup = valueGroup;
        this.typeId = typeId;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    abstract int valueSize(GenericKey var1);

    abstract void copyValue(GenericKey var1, GenericKey var2);

    void minimalSplitter(GenericKey left, GenericKey right, GenericKey into) {
        into.copyFrom(right);
    }

    abstract Value asValue(GenericKey var1);

    abstract int compareValue(GenericKey var1, GenericKey var2);

    abstract void putValue(PageCursor var1, GenericKey var2);

    abstract boolean readValue(PageCursor var1, int var2, GenericKey var3);

    void initializeAsLowest(GenericKey state) {
        state.writeValue(this.minValue, NativeIndexKey.Inclusion.LOW);
    }

    void initializeAsHighest(GenericKey state) {
        state.writeValue(this.maxValue, NativeIndexKey.Inclusion.HIGH);
    }

    String toString(GenericKey state) {
        return this.asValue(state).toString();
    }

    static byte[] ensureBigEnough(byte[] array, int targetLength) {
        return array == null || array.length < targetLength ? new byte[targetLength] : array;
    }

    static byte[][] ensureBigEnough(byte[][] array, int targetLength) {
        return array == null || array.length < targetLength ? new byte[targetLength][] : (byte[][])array;
    }

    static long[] ensureBigEnough(long[] array, int targetLength) {
        return array == null || array.length < targetLength ? new long[targetLength] : array;
    }

    static boolean booleanOf(long longValue) {
        return (longValue & 1L) == 1L;
    }
}

