/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedLongObjectMap;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class CachingOffHeapBlockAllocator
implements OffHeapBlockAllocator {
    private final SynchronizedLongObjectMap<BlockingQueue<OffHeapBlockAllocator.MemoryBlock>> pool = new SynchronizedLongObjectMap((MutableLongObjectMap)new LongObjectHashMap());
    private final long maxCacheableBlockSize;
    private final int maxCachedBlocks;
    private volatile boolean released;

    public CachingOffHeapBlockAllocator() {
        this(ByteUnit.kibiBytes((long)512L) + 8L - 1L, 128);
    }

    public CachingOffHeapBlockAllocator(long maxCacheableBlockSize, int maxCachedBlocks) {
        this.maxCacheableBlockSize = Preconditions.requireNonNegative((long)maxCacheableBlockSize);
        this.maxCachedBlocks = Preconditions.requireNonNegative((int)maxCachedBlocks);
    }

    @Override
    public OffHeapBlockAllocator.MemoryBlock allocate(long size, MemoryAllocationTracker tracker) {
        Preconditions.requirePositive((long)size);
        if (size > this.maxCacheableBlockSize || Long.bitCount(size) > 1) {
            return this.allocateNew(size, tracker);
        }
        BlockingQueue cached = (BlockingQueue)this.pool.getIfAbsentPut(size, (Function0 & Serializable)() -> new ArrayBlockingQueue(this.maxCachedBlocks));
        OffHeapBlockAllocator.MemoryBlock block = (OffHeapBlockAllocator.MemoryBlock)cached.poll();
        if (block == null) {
            block = this.allocateNew(size, tracker);
        } else {
            tracker.allocated(block.unalignedSize);
            UnsafeUtil.setMemory((long)block.unalignedAddr, (long)block.unalignedSize, (byte)0);
        }
        return block;
    }

    @Override
    public void free(OffHeapBlockAllocator.MemoryBlock block, MemoryAllocationTracker tracker) {
        if (this.released || block.size > this.maxCacheableBlockSize || Long.bitCount(block.size) > 1) {
            this.doFree(block, tracker);
            return;
        }
        BlockingQueue cached = (BlockingQueue)this.pool.getIfAbsentPut(block.size, (Function0 & Serializable)() -> new ArrayBlockingQueue(this.maxCachedBlocks));
        if (cached.offer(block)) {
            tracker.deallocated(block.unalignedSize);
        } else {
            this.doFree(block, tracker);
        }
    }

    @Override
    public void release() {
        this.released = true;
        this.pool.forEach((Procedure & Serializable)cached -> cached.forEach(block -> UnsafeUtil.free((long)block.unalignedAddr, (long)block.unalignedSize)));
        this.pool.clear();
    }

    @VisibleForTesting
    void doFree(OffHeapBlockAllocator.MemoryBlock block, MemoryAllocationTracker tracker) {
        UnsafeUtil.free((long)block.unalignedAddr, (long)block.unalignedSize, (MemoryAllocationTracker)tracker);
    }

    @VisibleForTesting
    OffHeapBlockAllocator.MemoryBlock allocateNew(long size, MemoryAllocationTracker tracker) {
        long unalignedSize = Preconditions.requirePositive((long)size) + 8L - 1L;
        long unalignedAddr = UnsafeUtil.allocateMemory((long)unalignedSize, (MemoryAllocationTracker)tracker);
        long addr = UnsafeUtil.alignedMemory((long)unalignedAddr, (int)8);
        UnsafeUtil.setMemory((long)unalignedAddr, (long)unalignedSize, (byte)0);
        return new OffHeapBlockAllocator.MemoryBlock(addr, size, unalignedAddr, unalignedSize);
    }
}

