/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.io.IOUtils;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NodeValueInjector
implements IndexProgressor.NodeValueClient,
IndexProgressor {
    private final IndexProgressor.NodeValueClient target;
    private final NodeCursor node;
    private final PropertyCursor property;
    private final int[] propertyKeyIds;
    private final Read read;
    private IndexProgressor progressor;

    NodeValueInjector(IndexProgressor.NodeValueClient target, NodeCursor node, PropertyCursor property, Read read, int[] propertyKeyIds) {
        this.target = target;
        this.node = node;
        this.property = property;
        this.propertyKeyIds = propertyKeyIds;
        this.read = read;
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues) {
        Preconditions.checkArgument((boolean)needsValues, (String)"No point in injecting values that are not needed!", (Object[])new Object[0]);
        this.progressor = progressor;
        this.target.initialize(descriptor, (IndexProgressor)this, query, indexOrder, needsValues);
    }

    public boolean acceptNode(long reference, Value[] values) {
        Preconditions.checkArgument((values != null ? 1 : 0) != 0, (String)"Can only inject missing parts, not whole value array!", (Object[])new Object[0]);
        int nMissing = this.countMissingValues(values);
        if (nMissing > 0) {
            this.read.singleNode(reference, this.node);
            if (!this.node.next()) {
                return false;
            }
            this.node.properties(this.property);
            while (nMissing > 0 && this.property.next()) {
                for (int i = 0; i < this.propertyKeyIds.length; ++i) {
                    Value value = values[i];
                    if (value != null && value != Values.NO_VALUE || this.property.propertyKey() != this.propertyKeyIds[i]) continue;
                    values[i] = this.property.propertyValue();
                    --nMissing;
                }
            }
        }
        return this.target.acceptNode(reference, values);
    }

    private int countMissingValues(Value[] values) {
        int nMissing = 0;
        for (Value v : values) {
            if (v != null && v != Values.NO_VALUE) continue;
            ++nMissing;
        }
        return nMissing;
    }

    public boolean needsValues() {
        return true;
    }

    public boolean next() {
        return this.progressor.next();
    }

    public void close() {
        IOUtils.closeAll(RuntimeException.class, (AutoCloseable[])new AutoCloseable[]{this.node, this.property, this.progressor});
    }
}

