/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.TextType;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class TextArrayType
extends AbstractArrayType<String> {
    TextArrayType(byte typeId) {
        super(ValueGroup.TEXT_ARRAY, typeId, (o1, o2, i) -> TextType.compare(o1.byteArrayArray[i], o1.long0Array[i], o1.long2, o1.long3, o2.byteArrayArray[i], o2.long0Array[i], o2.long2, o2.long3), (k, i) -> TextArrayType.asValueRaw(k.byteArrayArray[i], k.long0Array[i]), (c, k, i) -> TextType.put(c, k.byteArrayArray[i], k.long0Array[i], 0L), null, String[]::new, ValueWriter.ArrayType.STRING);
    }

    @Override
    int valueSize(GenericKeyState state) {
        int stringArraySize = 0;
        for (int i = 0; i < state.arrayLength; ++i) {
            stringArraySize += TextType.textKeySize(state.long0Array[i]);
        }
        return 2 + stringArraySize;
    }

    @Override
    void copyValue(GenericKeyState to, GenericKeyState from, int length) {
        to.long1 = 0L;
        to.long2 = from.long2;
        to.long3 = from.long3;
        this.initializeArray(to, length, null);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
        for (int i = 0; i < length; ++i) {
            short targetLength = (short)from.long0Array[i];
            to.byteArrayArray[i] = TextArrayType.ensureBigEnough(to.byteArrayArray[i], (int)targetLength);
            System.arraycopy(from.byteArrayArray[i], 0, to.byteArrayArray[i], 0, targetLength);
        }
    }

    @Override
    void initializeArray(GenericKeyState key, int length, ValueWriter.ArrayType arrayType) {
        key.long0Array = TextArrayType.ensureBigEnough(key.long0Array, length);
        key.byteArrayArray = TextArrayType.ensureBigEnough(key.byteArrayArray, length);
        if (arrayType == ValueWriter.ArrayType.CHAR) {
            key.long2 |= 2L;
        }
    }

    @Override
    void putValue(PageCursor cursor, GenericKeyState state) {
        short typeMarker = (short)(TextType.isCharValueType(state.long2) ? 32768 : 0);
        TextArrayType.putArrayHeader(cursor, (short)(GenericKeyState.toNonNegativeShortExact(state.arrayLength) | typeMarker));
        TextArrayType.putArrayItems(cursor, state, this.arrayElementWriter);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKeyState into) {
        short rawLength = cursor.getShort();
        boolean isCharType = (rawLength & 0x8000) != 0;
        short length = (short)(rawLength & 0xFFFF7FFF);
        if (!TextArrayType.setArrayLengthWhenReading(into, cursor, length)) {
            return false;
        }
        into.beginArray(into.arrayLength, isCharType ? ValueWriter.ArrayType.CHAR : ValueWriter.ArrayType.STRING);
        for (int i = 0; i < into.arrayLength; ++i) {
            short bytesLength = cursor.getShort();
            if (bytesLength < 0 || bytesLength > size) {
                GenericKeyState.setCursorException(cursor, "non-valid bytes length, " + bytesLength);
                return false;
            }
            into.byteArrayArray[i] = TextArrayType.ensureBigEnough(into.byteArrayArray[i], (int)bytesLength);
            into.long0Array[i] = bytesLength;
            cursor.getBytes(into.byteArrayArray[i], 0, (int)bytesLength);
        }
        into.endArray();
        return true;
    }

    @Override
    Value asValue(GenericKeyState state) {
        if (TextType.isCharValueType(state.long2)) {
            return this.charArrayAsValue(state);
        }
        return super.asValue(state);
    }

    private Value charArrayAsValue(GenericKeyState state) {
        char[] chars = new char[state.arrayLength];
        for (int i = 0; i < state.arrayLength; ++i) {
            chars[i] = TextType.textAsChar(state.byteArrayArray[i]);
        }
        return Values.charArray((char[])chars);
    }

    static String asValueRaw(byte[] byteArray, long long0) {
        return byteArray == null ? null : UTF8.decode((byte[])byteArray, (int)0, (int)((int)long0));
    }

    void write(GenericKeyState state, int offset, byte[] bytes) {
        state.byteArrayArray[offset] = bytes;
        state.long0Array[offset] = bytes.length;
    }
}

